/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.session;

import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ServletSessionConfig;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletURLRewritingSessionTestCase {
    public static final String COUNT = "count";

    @BeforeClass
    public static void setup() {
        DeploymentUtils.setupServlet(new ServletExtension(){

            public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
                deploymentInfo.setServletSessionConfig(new ServletSessionConfig().setSessionTrackingModes(Collections.singleton(SessionTrackingMode.URL)));
            }
        }, Servlets.servlet(URLRewritingServlet.class).addMapping("/foo"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testURLRewriting() throws IOException {
        TestHttpClient client = new TestHttpClient();
        client.setCookieStore((CookieStore)new BasicCookieStore());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/foo;foo=bar");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String url = HttpClientUtils.readResponse((HttpResponse)result);
            Header[] header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"0", (Object)header[0].getValue());
            get = new HttpGet(url);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            url = HttpClientUtils.readResponse((HttpResponse)result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"1", (Object)header[0].getValue());
            get = new HttpGet(url);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            url = HttpClientUtils.readResponse((HttpResponse)result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"2", (Object)header[0].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testURLRewritingWithQueryParameters() throws IOException {
        TestHttpClient client = new TestHttpClient();
        client.setCookieStore((CookieStore)new BasicCookieStore());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/foo?a=b;c");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String url = HttpClientUtils.readResponse((HttpResponse)result);
            Header[] header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"0", (Object)header[0].getValue());
            Assert.assertEquals((Object)"b;c", (Object)result.getHeaders("a")[0].getValue());
            get = new HttpGet(url);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            url = HttpClientUtils.readResponse((HttpResponse)result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"1", (Object)header[0].getValue());
            Assert.assertEquals((Object)"b;c", (Object)result.getHeaders("a")[0].getValue());
            get = new HttpGet(url);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            url = HttpClientUtils.readResponse((HttpResponse)result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"2", (Object)header[0].getValue());
            Assert.assertEquals((Object)"b;c", (Object)result.getHeaders("a")[0].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testURLRewritingWithExistingOldSessionId() throws IOException {
        TestHttpClient client = new TestHttpClient();
        client.setCookieStore((CookieStore)new BasicCookieStore());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/foo;jsessionid=foobar");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String url = HttpClientUtils.readResponse((HttpResponse)result);
            Header[] header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"0", (Object)header[0].getValue());
            get = new HttpGet(url);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            url = HttpClientUtils.readResponse((HttpResponse)result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"1", (Object)header[0].getValue());
            get = new HttpGet(url);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            url = HttpClientUtils.readResponse((HttpResponse)result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"2", (Object)header[0].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testURLRewritingWithExistingOldSessionIdAndOtherPathParams() throws IOException {
        TestHttpClient client = new TestHttpClient();
        client.setCookieStore((CookieStore)new BasicCookieStore());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/foo;jsessionid=foobar&a=b");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String url = HttpClientUtils.readResponse((HttpResponse)result);
            Header[] header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"0", (Object)header[0].getValue());
            get = new HttpGet(url);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            url = HttpClientUtils.readResponse((HttpResponse)result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"1", (Object)header[0].getValue());
            get = new HttpGet(url);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            url = HttpClientUtils.readResponse((HttpResponse)result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"2", (Object)header[0].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRequestedSessionId() throws IOException {
        try (TestHttpClient client = new TestHttpClient();){
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/foo");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/foo;jsessionid=test");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
    }

    public static class URLRewritingServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            String sessionIdBefore = req.getRequestedSessionId();
            HttpSession session = req.getSession(true);
            String sessionIdAfter = req.getRequestedSessionId();
            Assert.assertEquals((String)String.format("sessionIdBefore %s, sessionIdAfter %s", sessionIdBefore, sessionIdAfter), (Object)sessionIdBefore, (Object)sessionIdAfter);
            Object existing = session.getAttribute(ServletURLRewritingSessionTestCase.COUNT);
            if (existing == null) {
                session.setAttribute(ServletURLRewritingSessionTestCase.COUNT, (Object)0);
            } else {
                Assert.assertTrue((boolean)req.getRequestURI().startsWith("/servletContext/foo;"));
                Assert.assertTrue((boolean)req.getRequestURI().contains("jsessionid=" + session.getId()));
            }
            Integer count = (Integer)session.getAttribute(ServletURLRewritingSessionTestCase.COUNT);
            resp.addHeader(ServletURLRewritingSessionTestCase.COUNT, count.toString());
            count = count + 1;
            session.setAttribute(ServletURLRewritingSessionTestCase.COUNT, (Object)count);
            for (Map.Entry qp : req.getParameterMap().entrySet()) {
                resp.addHeader((String)qp.getKey(), ((String[])qp.getValue())[0]);
            }
            if (req.getQueryString() == null) {
                resp.getWriter().write(resp.encodeURL(DefaultServer.getDefaultServerURL() + req.getRequestURI()));
            } else {
                resp.getWriter().write(resp.encodeURL(DefaultServer.getDefaultServerURL() + req.getRequestURI() + "?" + req.getQueryString()));
            }
        }
    }
}

