/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.streams;

import io.undertow.servlet.test.streams.ServletOutputStreamTestCase;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletOutputStreamSSLTestCase
extends ServletOutputStreamTestCase {
    @BeforeClass
    public static void ssl() throws Exception {
        DefaultServer.startSSLServer();
    }

    @AfterClass
    public static void stopssl() throws IOException {
        DefaultServer.stopSSLServer();
    }

    @Override
    protected TestHttpClient createClient() {
        TestHttpClient client = super.createClient();
        client.setSSLContext(DefaultServer.createClientSslContext());
        return client;
    }

    @Override
    protected String getBaseUrl() {
        return DefaultServer.getDefaultServerSSLAddress();
    }

    @Override
    public void testAsyncServletOutputStreamOffIOThread() {
        Assume.assumeFalse((System.getProperty("os.name").startsWith("Windows") && DefaultServer.isProxy() && DefaultServer.isAjp() ? 1 : 0) != 0);
        super.testAsyncServletOutputStreamOffIOThread();
    }

    @Override
    public void testAsyncServletOutputStreamWithPreable() {
        Assume.assumeFalse((System.getProperty("os.name").startsWith("Windows") && DefaultServer.isProxy() && DefaultServer.isAjp() ? 1 : 0) != 0);
        super.testAsyncServletOutputStreamWithPreable();
    }
}

