/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.upgrade;

import io.undertow.UndertowLogger;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.WebConnection;
import java.io.IOException;

public class UpgradeServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.upgrade(Handler.class);
    }

    public static class Handler
    implements HttpUpgradeHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init(WebConnection wc) {
            try {
                StringBuilder builder;
                String message = "";
                do {
                    int read;
                    builder = new StringBuilder();
                    byte[] data = new byte[100];
                    while (!builder.toString().endsWith("\r\n\r\n") && (read = wc.getInputStream().read(data)) != -1) {
                        builder.append(new String(data, 0, read));
                    }
                    wc.getOutputStream().print(builder.toString());
                    wc.getOutputStream().flush();
                } while (!"exit\r\n\r\n".equals(message = builder.toString()));
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            }
            finally {
                try {
                    wc.close();
                }
                catch (Exception e) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(e));
                }
            }
        }

        public void destroy() {
        }
    }
}

