/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.util;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Map;

public class ParameterEchoServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String echoType = req.getParameter("type");
        if (echoType == null) {
            echoType = "values";
        }
        StringBuilder sb = new StringBuilder();
        if (echoType.equals("values")) {
            sb = this.echoParameterValues(req);
        } else if (echoType.equals("names")) {
            sb = this.echoParameterNames(req);
        } else if (echoType.equals("map")) {
            sb = this.echoParameterMap(req);
        } else {
            resp.sendError(400);
            return;
        }
        PrintWriter writer = resp.getWriter();
        writer.write(sb.toString());
        writer.close();
    }

    private StringBuilder echoParameterMap(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        Map map = req.getParameterMap();
        for (Map.Entry entry : map.entrySet()) {
            sb.append((String)entry.getKey()).append("=");
            for (int i = 0; i < ((String[])entry.getValue()).length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(((String[])entry.getValue())[i]);
            }
            sb.append(";");
        }
        return sb;
    }

    private StringBuilder echoParameterNames(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            sb.append((String)names.nextElement());
            if (!names.hasMoreElements()) continue;
            sb.append(",");
        }
        return sb;
    }

    private StringBuilder echoParameterValues(HttpServletRequest req) {
        int i;
        StringBuilder sb = new StringBuilder();
        String[] param1Values = req.getParameterValues("param1");
        String[] param2Values = req.getParameterValues("param2");
        String[] param3Values = req.getParameterValues("param3");
        if (param1Values != null) {
            sb.append("param1='");
            for (i = 0; i < param1Values.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(param1Values[i]);
            }
            sb.append('\'');
        }
        if (param2Values != null) {
            sb.append("param2='");
            for (i = 0; i < param2Values.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(param2Values[i]);
            }
            sb.append('\'');
        }
        if (param3Values != null) {
            sb.append("param3='");
            for (i = 0; i < param3Values.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(param3Values[i]);
            }
            sb.append('\'');
        }
        return sb;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

