/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.util;

import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class TestListener
implements ServletRequestListener {
    private static final List<String> RESULTS = Collections.synchronizedList(new ArrayList());
    private static volatile CountDownLatch latch;

    public static void addMessage(String message) {
        RESULTS.add(message);
        latch.countDown();
    }

    public static void init(int count) {
        RESULTS.clear();
        latch = new CountDownLatch(count);
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        RESULTS.add("destroyed " + sre.getServletRequest().getDispatcherType());
        latch.countDown();
    }

    public void requestInitialized(ServletRequestEvent sre) {
        RESULTS.add("created " + sre.getServletRequest().getDispatcherType());
        latch.countDown();
    }

    public static List<String> results() {
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return RESULTS;
    }
}

