/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.wrapper;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import org.wildfly.common.Assert;

public class NonStandardRequestWrapper
implements HttpServletRequest {
    private ServletRequest request;

    public NonStandardRequestWrapper(ServletRequest request) {
        this.request = (ServletRequest)Assert.checkNotNullParam((String)"request", (Object)request);
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(ServletRequest request) {
        this.request = (ServletRequest)Assert.checkNotNullParam((String)"request", (Object)request);
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(enc);
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public long getContentLengthLong() {
        return this.request.getContentLengthLong();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.request.getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.request.getParameterValues(name);
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        this.request.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.request.getLocales();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.request.getRequestDispatcher(path);
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public String getLocalName() {
        return this.request.getLocalName();
    }

    public String getLocalAddr() {
        return this.request.getLocalAddr();
    }

    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    public ServletContext getServletContext() {
        return this.request.getServletContext();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.request.startAsync();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return this.request.startAsync(servletRequest, servletResponse);
    }

    public boolean isAsyncStarted() {
        return this.request.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.request.isAsyncSupported();
    }

    public AsyncContext getAsyncContext() {
        return this.request.getAsyncContext();
    }

    public boolean isWrapperFor(ServletRequest wrapped) {
        if (this.request == wrapped) {
            return true;
        }
        if (this.request instanceof ServletRequestWrapper) {
            return ((ServletRequestWrapper)this.request).isWrapperFor(wrapped);
        }
        return false;
    }

    public boolean isWrapperFor(Class<?> wrappedType) {
        if (!ServletRequest.class.isAssignableFrom(wrappedType)) {
            throw new IllegalArgumentException("Given class " + wrappedType.getName() + " not a subinterface of " + ServletRequest.class.getName());
        }
        if (wrappedType.isAssignableFrom(this.request.getClass())) {
            return true;
        }
        if (this.request instanceof ServletRequestWrapper) {
            return ((ServletRequestWrapper)this.request).isWrapperFor(wrappedType);
        }
        return false;
    }

    public DispatcherType getDispatcherType() {
        return this.request.getDispatcherType();
    }

    private HttpServletRequest _getHttpServletRequest() {
        return (HttpServletRequest)this.getRequest();
    }

    public String getAuthType() {
        return this._getHttpServletRequest().getAuthType();
    }

    public Cookie[] getCookies() {
        return this._getHttpServletRequest().getCookies();
    }

    public long getDateHeader(String name) {
        return this._getHttpServletRequest().getDateHeader(name);
    }

    public String getHeader(String name) {
        return this._getHttpServletRequest().getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this._getHttpServletRequest().getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this._getHttpServletRequest().getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this._getHttpServletRequest().getIntHeader(name);
    }

    public String getMethod() {
        return this._getHttpServletRequest().getMethod();
    }

    public String getPathInfo() {
        return this._getHttpServletRequest().getPathInfo();
    }

    public String getPathTranslated() {
        return this._getHttpServletRequest().getPathTranslated();
    }

    public String getContextPath() {
        return this._getHttpServletRequest().getContextPath();
    }

    public String getQueryString() {
        return this._getHttpServletRequest().getQueryString();
    }

    public String getRemoteUser() {
        return this._getHttpServletRequest().getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this._getHttpServletRequest().isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this._getHttpServletRequest().getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this._getHttpServletRequest().getRequestedSessionId();
    }

    public String getRequestURI() {
        return this._getHttpServletRequest().getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this._getHttpServletRequest().getRequestURL();
    }

    public String getServletPath() {
        return this._getHttpServletRequest().getServletPath();
    }

    public HttpSession getSession(boolean create) {
        return this._getHttpServletRequest().getSession(create);
    }

    public HttpSession getSession() {
        return this._getHttpServletRequest().getSession();
    }

    public String changeSessionId() {
        return this._getHttpServletRequest().changeSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this._getHttpServletRequest().isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._getHttpServletRequest().isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._getHttpServletRequest().isRequestedSessionIdFromURL();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return this._getHttpServletRequest().authenticate(response);
    }

    public void login(String username, String password) throws ServletException {
        this._getHttpServletRequest().login(username, password);
    }

    public void logout() throws ServletException {
        this._getHttpServletRequest().logout();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this._getHttpServletRequest().getParts();
    }

    public Part getPart(String name) throws IOException, ServletException {
        return this._getHttpServletRequest().getPart(name);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        return (T)this._getHttpServletRequest().upgrade(handlerClass);
    }

    public String getRequestId() {
        return this._getHttpServletRequest().getRequestId();
    }

    public String getProtocolRequestId() {
        return this._getHttpServletRequest().getProtocolRequestId();
    }

    public ServletConnection getServletConnection() {
        return this._getHttpServletRequest().getServletConnection();
    }
}

