/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ProxyPeerAddressHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.util.ProxyPeerXForwardedHandlerServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@ProxyIgnore
public class ProxyXForwardedTestCase {
    protected static int PORT;

    @BeforeClass
    public static void setup() throws ServletException {
        PORT = DefaultServer.getHostPort((String)"default");
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("servlet", ProxyPeerXForwardedHandlerServlet.class).addMapping("/proxyPeerHandler");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlet(s);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        HttpHandler startHandler = manager.start();
        startHandler = new ProxyPeerAddressHandler(startHandler, false);
        root.addPrefixPath(builder.getContextPath(), startHandler);
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxyPeerHandler() throws IOException, ServletException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet getProxyPeerHandler = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/proxyPeerHandler");
            getProxyPeerHandler.addHeader("X-Forwarded-For", "192.0.2.43");
            getProxyPeerHandler.addHeader("X-Forwarded-Proto", "http");
            getProxyPeerHandler.addHeader("X-Forwarded-Host", "192.0.2.10");
            getProxyPeerHandler.addHeader("X-Forwarded-Port", "8888");
            CloseableHttpResponse result = client.execute((HttpUriRequest)getProxyPeerHandler);
            HttpEntity entity = result.getEntity();
            String results = EntityUtils.toString((HttpEntity)entity);
            Map<String, String> map = this.convertWithStream(results);
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(DefaultServer.getHostAddress(), PORT));
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)socket.getLocalAddress().getHostAddress(), (Object)map.get("localAddr"));
            Assert.assertEquals((Object)socket.getLocalAddress().getHostName(), (Object)map.get("localName"));
            Assert.assertEquals((long)PORT, (long)Integer.parseInt(map.get("localPort")));
            Assert.assertEquals((Object)"192.0.2.10", (Object)map.get("serverName"));
            Assert.assertEquals((Object)"8888", (Object)map.get("serverPort"));
            Assert.assertEquals((Object)"192.0.2.43", (Object)map.get("remoteAddr"));
            Assert.assertEquals((Object)"0", (Object)map.get("remotePort"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private Map<String, String> convertWithStream(String mapAsString) {
        Map<String, String> map = new HashMap<String, String>();
        if (mapAsString != null) {
            mapAsString = mapAsString.substring(1, mapAsString.length() - 1);
            map = Arrays.stream(mapAsString.split(",")).map(entry -> entry.split("=")).collect(Collectors.toMap(entry -> entry[0].trim(), entry -> entry[1].trim()));
        }
        return map;
    }
}

