/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.listener.request.async.onComplete;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ExceptionHandler;
import io.undertow.servlet.api.LoggingExceptionHandler;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.listener.request.async.onComplete.OnCompleteServlet;
import io.undertow.servlet.test.util.MessageServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class AsyncListenerOnCompleteTest {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo f = new ServletInfo("asyncServlet", OnCompleteServlet.class).addMapping("/async").setAsyncSupported(true);
        ServletInfo a1 = new ServletInfo("message", MessageServlet.class).setAsyncSupported(true).addInitParam("message", "Hello").addMapping("/message");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(AsyncListenerOnCompleteTest.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlets(new ServletInfo[]{f, a1});
        builder.setExceptionHandler((ExceptionHandler)LoggingExceptionHandler.builder().add(IllegalStateException.class, "io.undertow", Logger.Level.DEBUG).build());
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnCompleteWithNoCompleteCalled() throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/async");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Hello", (Object)response);
            Assert.assertEquals((Object)"onComplete", (Object)OnCompleteServlet.QUEUE.poll(10L, TimeUnit.SECONDS));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

