/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.path;

import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.path.GetMappingServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.MappingMatch;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class MultipleMatchingMappingTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        DeploymentUtils.setupServlet(new ServletInfo("path", GetMappingServlet.class).addMapping("/path/*").addMapping("/*").addMapping("*.ext"));
    }

    @Test
    public void testMatchesPathAndExtension1() {
        MultipleMatchingMappingTestCase.doTest("/foo.ext", MappingMatch.PATH, "foo.ext", "/*", "path");
    }

    @Test
    public void testMatchesPathAndExtension2() {
        MultipleMatchingMappingTestCase.doTest("/other/foo.ext", MappingMatch.PATH, "other/foo.ext", "/*", "path");
    }

    @Test
    public void testMatchesPathAndExtension3() {
        MultipleMatchingMappingTestCase.doTest("/path/foo.ext", MappingMatch.PATH, "foo.ext", "/path/*", "path");
    }

    private static void doTest(String path, MappingMatch mappingMatch, String matchValue, String pattern, String servletName) {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext" + path);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            String expected = String.format("Mapping match:%s\nMatch value:%s\nPattern:%s\nServlet:%s", mappingMatch.name(), matchValue, pattern, servletName);
            Assert.assertEquals((Object)expected, (Object)response);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

