/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.request;

import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.request.RaceyAddServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ExecutorPerServletTestCase {
    private ExecutorService executorService;
    public static final int NUM_THREADS = 10;
    public static final int NUM_REQUESTS = 100;

    @Before
    public void setup() throws ServletException {
        ServletInfo[] servletInfoArray = new ServletInfo[2];
        servletInfoArray[0] = new ServletInfo("racey", RaceyAddServlet.class).addMapping("/racey");
        this.executorService = Executors.newSingleThreadExecutor();
        servletInfoArray[1] = new ServletInfo("single", RaceyAddServlet.class).addMapping("/single").setExecutor((Executor)this.executorService);
        DeploymentUtils.setupServlet(servletInfoArray);
    }

    @After
    public void after() {
        this.executorService.shutdown();
    }

    @Test
    @Ignore(value="This won't pass every run, but on most machines it should pass consistently")
    public void testRaceyServlet() throws InterruptedException, ExecutionException, IOException {
        Assert.assertNotEquals((long)1000L, (long)this.runTest("/racey"));
    }

    @Test
    public void testSingleThreadExecutor() throws InterruptedException, ExecutionException, IOException {
        Assert.assertEquals((long)1000L, (long)this.runTest("/single"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runTest(final String path) throws IOException, ExecutionException, InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            int n;
            ArrayList futures = new ArrayList();
            for (int i = 0; i < 10; ++i) {
                futures.add(executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        TestHttpClient client = new TestHttpClient();
                        try {
                            for (int i = 0; i < 100; ++i) {
                                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext" + path);
                                CloseableHttpResponse result = client.execute((HttpUriRequest)get);
                                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                                String string = HttpClientUtils.readResponse((HttpResponse)result);
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            client.getConnectionManager().shutdown();
                        }
                    }
                }));
            }
            for (Future future : futures) {
                future.get();
            }
            TestHttpClient client = new TestHttpClient();
            try {
                HttpGet httpGet = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext" + path);
                CloseableHttpResponse result = client.execute((HttpUriRequest)httpGet);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                n = Integer.parseInt(HttpClientUtils.readResponse((HttpResponse)result));
            }
            catch (Throwable throwable) {
                client.getConnectionManager().shutdown();
                throw throwable;
            }
            client.getConnectionManager().shutdown();
            return n;
        }
        finally {
            executor.shutdown();
        }
    }
}

