/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.spec;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.util.ParameterEchoServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ParameterEchoTestCase {
    public static final String RESPONSE = "param1='1'param2='2'param3='3'";

    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("servlet", ParameterEchoServlet.class).addMapping("/aaa");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(ParameterEchoTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlet(s);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostInUrl() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/servletContext/aaa?param1=1&param2=2&param3=3");
            ArrayList values = new ArrayList();
            UrlEncodedFormEntity data = new UrlEncodedFormEntity(values, "UTF-8");
            post.setEntity((HttpEntity)data);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)RESPONSE, (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostInStream() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/servletContext/aaa");
            ArrayList<BasicNameValuePair> values = new ArrayList<BasicNameValuePair>();
            values.add(new BasicNameValuePair("param1", "1"));
            values.add(new BasicNameValuePair("param2", "2"));
            values.add(new BasicNameValuePair("param3", "3"));
            UrlEncodedFormEntity data = new UrlEncodedFormEntity(values, "UTF-8");
            post.setEntity((HttpEntity)data);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)RESPONSE, (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostBoth() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/servletContext/aaa?param1=1&param2=2");
            ArrayList<BasicNameValuePair> values = new ArrayList<BasicNameValuePair>();
            values.add(new BasicNameValuePair("param3", "3"));
            UrlEncodedFormEntity data = new UrlEncodedFormEntity(values, "UTF-8");
            post.setEntity((HttpEntity)data);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)RESPONSE, (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutBothValues() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPut put = new HttpPut(DefaultServer.getDefaultServerURL() + "/servletContext/aaa?param1=1&param2=2");
            ArrayList<BasicNameValuePair> values = new ArrayList<BasicNameValuePair>();
            values.add(new BasicNameValuePair("param3", "3"));
            UrlEncodedFormEntity data = new UrlEncodedFormEntity(values, "UTF-8");
            put.setEntity((HttpEntity)data);
            CloseableHttpResponse result = client.execute((HttpUriRequest)put);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)RESPONSE, (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutNames() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPut put = new HttpPut(DefaultServer.getDefaultServerURL() + "/servletContext/aaa?type=names");
            ArrayList<BasicNameValuePair> values = new ArrayList<BasicNameValuePair>();
            values.add(new BasicNameValuePair("param1", "1"));
            values.add(new BasicNameValuePair("param2", "2"));
            values.add(new BasicNameValuePair("param3", "3"));
            UrlEncodedFormEntity data = new UrlEncodedFormEntity(values, "UTF-8");
            put.setEntity((HttpEntity)data);
            CloseableHttpResponse result = client.execute((HttpUriRequest)put);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            List<String> resList = Arrays.asList(HttpClientUtils.readResponse((HttpResponse)result).split(","));
            Assert.assertEquals((long)4L, (long)resList.size());
            Assert.assertTrue((boolean)resList.contains("type"));
            Assert.assertTrue((boolean)resList.contains("param1"));
            Assert.assertTrue((boolean)resList.contains("param2"));
            Assert.assertTrue((boolean)resList.contains("param3"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutMap() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPut put = new HttpPut(DefaultServer.getDefaultServerURL() + "/servletContext/aaa?type=map");
            ArrayList<BasicNameValuePair> values = new ArrayList<BasicNameValuePair>();
            values.add(new BasicNameValuePair("param1", "1"));
            values.add(new BasicNameValuePair("param2", "2"));
            values.add(new BasicNameValuePair("param3", "3"));
            UrlEncodedFormEntity data = new UrlEncodedFormEntity(values, "UTF-8");
            put.setEntity((HttpEntity)data);
            CloseableHttpResponse result = client.execute((HttpUriRequest)put);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            List<String> resList = Arrays.asList(HttpClientUtils.readResponse((HttpResponse)result).split(";"));
            Assert.assertEquals((long)4L, (long)resList.size());
            Assert.assertTrue((boolean)resList.contains("type=map"));
            Assert.assertTrue((boolean)resList.contains("param1=1"));
            Assert.assertTrue((boolean)resList.contains("param2=2"));
            Assert.assertTrue((boolean)resList.contains("param3=3"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

