/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.streams;

import io.undertow.servlet.test.streams.ServletOutputStreamTestCase;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncOutputStreamServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        final boolean flush = req.getParameter("flush") != null;
        final boolean close = req.getParameter("close") != null;
        boolean preable = req.getParameter("preamble") != null;
        boolean offIoThread = req.getParameter("offIoThread") != null;
        final int reps = Integer.parseInt(req.getParameter("reps"));
        final AtomicInteger count = new AtomicInteger();
        final AsyncContext context = req.startAsync();
        final ServletOutputStream outputStream = resp.getOutputStream();
        if (preable) {
            for (int i = 0; i < reps; ++i) {
                outputStream.write(ServletOutputStreamTestCase.message.getBytes());
            }
        }
        final WriteListener listener = new WriteListener(){

            public synchronized void onWritePossible() throws IOException {
                while (outputStream.isReady() && count.get() < reps) {
                    count.incrementAndGet();
                    outputStream.write(ServletOutputStreamTestCase.message.getBytes());
                }
                if (count.get() == reps) {
                    if (flush) {
                        outputStream.flush();
                    }
                    if (close) {
                        outputStream.close();
                    }
                    context.complete();
                }
            }

            public void onError(Throwable t) {
            }
        };
        outputStream.setWriteListener(offIoThread ? new WriteListener(){

            public void onWritePossible() throws IOException {
                context.start(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            listener.onWritePossible();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }

            public void onError(Throwable throwable) {
            }
        } : listener);
    }
}

