/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.defaultservlet;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletException;
import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class DefaultServletNoDirectoryListingTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(DefaultServletNoDirectoryListingTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war").setResourceManager((ResourceManager)new TestResourceLoader(DefaultServletNoDirectoryListingTestCase.class));
        builder.addServlet(new ServletInfo("default", DefaultServlet.class).addMapping("/*"));
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectoryListing() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            try (CloseableHttpResponse result = client.execute((HttpUriRequest)new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/path"));){
                Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
            }
            result = client.execute((HttpUriRequest)new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/path?js"));
            try {
                Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            result = client.execute((HttpUriRequest)new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/path?css"));
            try {
                Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

