/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.dispatcher;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.dispatcher.DispatcherIncludeServlet;
import io.undertow.servlet.test.dispatcher.IncludePathTestServlet;
import io.undertow.servlet.test.dispatcher.IncludeServlet;
import io.undertow.servlet.test.dispatcher.NextServlet;
import io.undertow.servlet.test.dispatcher.util.DispatcherUtil;
import io.undertow.servlet.test.util.MessageFilter;
import io.undertow.servlet.test.util.MessageServlet;
import io.undertow.servlet.test.util.ParameterEchoServlet;
import io.undertow.servlet.test.util.PathTestServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.common.Assert;

@RunWith(value=DefaultServer.class)
public class DispatcherIncludeTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setResourceManager((ResourceManager)new TestResourceLoader(DispatcherIncludeTestCase.class)).addServlet(new ServletInfo("include", MessageServlet.class).addInitParam("message", "included").addMapping("/include")).addServlet(new ServletInfo("dispatcher", IncludeServlet.class).addMapping("/dispatch").addMapping("/dispatch/*").addMapping("*.dispatch")).addServlet(new ServletInfo("pathTest", PathTestServlet.class).addMapping("/path")).addServlet(new ServletInfo("pathIncludeTest", IncludePathTestServlet.class).addMapping("/path-include").addMapping("/path-include/*").addMapping("*.includeinfo")).addServlet(new ServletInfo("parameterEcho", ParameterEchoServlet.class).addMapping("/echo-parameters")).addServlet(new ServletInfo("/dispatchServletInclude", DispatcherIncludeServlet.class).addMapping("/dispatchServletInclude")).addServlet(new ServletInfo("/next", NextServlet.class).addMapping("/next")).addFilter(new FilterInfo("notIncluded", MessageFilter.class).addInitParam("message", "Not Included")).addFilter(new FilterInfo("inc", MessageFilter.class).addInitParam("message", "Path!")).addFilter(new FilterInfo("nameFilter", MessageFilter.class).addInitParam("message", "Name!")).addFilterUrlMapping("notIncluded", "/include", DispatcherType.REQUEST).addFilterUrlMapping("inc", "/include", DispatcherType.INCLUDE).addFilterServletNameMapping("nameFilter", "include", DispatcherType.INCLUDE);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPathBasedInclude() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch");
            get.setHeader("include", "/include");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            org.junit.Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            org.junit.Assert.assertEquals((Object)"Hello Path!Name!included", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameBasedInclude() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch");
            get.setHeader("include", "include");
            get.setHeader("name", "true");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            org.junit.Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            org.junit.Assert.assertEquals((Object)"Hello Name!included", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPathBasedStaticInclude() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch");
            get.setHeader("include", "/snippet.html");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            org.junit.Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            org.junit.Assert.assertEquals((Object)"Hello SnippetText", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPathBasedStaticIncludePost() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch");
            post.setHeader("include", "/snippet.html");
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            org.junit.Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            org.junit.Assert.assertEquals((Object)"Hello SnippetText", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncludeAggregatesQueryString() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch?a=b");
            get.setHeader("include", "/path");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            org.junit.Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            org.junit.Assert.assertEquals((Object)"Hello pathInfo:null queryString:a=b servletPath:/dispatch requestUri:/servletContext/dispatch", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch?a=b");
            get.setHeader("include", "/path?foo=bar");
            result = client.execute((HttpUriRequest)get);
            org.junit.Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            org.junit.Assert.assertEquals((Object)"Hello pathInfo:null queryString:a=b servletPath:/dispatch requestUri:/servletContext/dispatch", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttributes() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch?n1=v1&n2=v2");
            get.setHeader("include", "/path-include?url=http://test.com");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            org.junit.Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"Hello pathInfo:null queryString:n1=v1&n2=v2 servletPath:/dispatch requestUri:/servletContext/dispatch\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.request_uri:/servletContext/path-include\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.context_path:/servletContext\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.servlet_path:/path-include\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.path_info:null\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.query_string:url=http://test.com\r\n"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttributesEncoded() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch/dis%25patch?n1=v1&n2=v%252");
            get.setHeader("include", "/path-include/path%25include?n2=v%253");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            org.junit.Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"Hello pathInfo:/dis%patch queryString:n1=v1&n2=v%252 servletPath:/dispatch requestUri:/servletContext/dispatch/dis%25patch\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.request_uri:/servletContext/path-include/path%25include\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.context_path:/servletContext\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.servlet_path:/path-include\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.path_info:/path%include\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.query_string:n2=v%253\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.mapping:"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttributesEncodedExtension() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dis%25patch.dispatch?n1=v1&n2=v%252");
            get.setHeader("include", "/path%25include.includeinfo?n2=v%253");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            org.junit.Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"Hello pathInfo:null queryString:n1=v1&n2=v%252 servletPath:/dis%patch.dispatch requestUri:/servletContext/dis%25patch.dispatch\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.request_uri:/servletContext/path%25include.includeinfo\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.context_path:/servletContext\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.servlet_path:/path%include.includeinfo\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.path_info:null\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.query_string:n2=v%253\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.mapping:"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParametersAreMerged() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch?param1=v11&param1=v12");
            get.setHeader("include", "/echo-parameters?param1=v13&param1=v14");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            org.junit.Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            org.junit.Assert.assertEquals((Object)"Hello param1='v13,v14,v11,v12'", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisptacherServletInclude() throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatchServletInclude");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            org.junit.Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)DispatcherUtil.containsWord(response, "jakarta.servlet.include.context_path"));
            Assert.assertTrue((boolean)DispatcherUtil.containsWord(response, "jakarta.servlet.include.servlet_path"));
            Assert.assertTrue((boolean)DispatcherUtil.containsWord(response, "jakarta.servlet.include.request_uri"));
            Assert.assertTrue((boolean)DispatcherUtil.containsWord(response, "jakarta.servlet.include.mapping"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisptacherServletIncludeNest() throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dis%25patch.dispatch?n1=v1&n2=v%252");
            String include = URLEncoder.encode("/path%25include.includeinfo?n4=v4", StandardCharsets.UTF_8);
            get.setHeader("include", "/servletContext/dis%25patch.dispatch?n3=v3&include=" + include);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            org.junit.Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"Hello pathInfo:null queryString:n1=v1&n2=v%252 servletPath:/dis%patch.dispatch requestUri:/servletContext/dis%25patch.dispatch\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.request_uri:/servletContext/path%25include.includeinfo\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.context_path:/servletContext\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.servlet_path:/path%include.includeinfo\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.path_info:null\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.query_string:n4=v4\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.include.mapping:"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"request params:include=/path%25include.includeinfo?n4=v4n1=v1n2=v%2n3=v3n4=v4\r\n"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

