/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.dispatcher;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

public class IncludePathTestServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try (PrintWriter out = resp.getWriter();){
            out.print("pathInfo:" + req.getPathInfo());
            out.print(" queryString:" + req.getQueryString());
            out.print(" servletPath:" + req.getServletPath());
            out.println(" requestUri:" + req.getRequestURI());
            out.println("jakarta.servlet.include.request_uri:" + req.getAttribute("jakarta.servlet.include.request_uri"));
            out.println("jakarta.servlet.include.context_path:" + req.getAttribute("jakarta.servlet.include.context_path"));
            out.println("jakarta.servlet.include.servlet_path:" + req.getAttribute("jakarta.servlet.include.servlet_path"));
            out.println("jakarta.servlet.include.path_info:" + req.getAttribute("jakarta.servlet.include.path_info"));
            out.println("jakarta.servlet.include.query_string:" + req.getAttribute("jakarta.servlet.include.query_string"));
            out.println("jakarta.servlet.include.mapping:" + req.getAttribute("jakarta.servlet.include.mapping"));
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : req.getParameterMap().entrySet()) {
                Optional<String> r = Arrays.stream((String[])entry.getValue()).reduce((i, j) -> i + "," + j);
                sb.append((String)entry.getKey()).append("=").append(r.orElse(""));
            }
            out.println("request params:" + sb);
        }
    }
}

