/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.dispatchingfilter;

import io.undertow.servlet.test.dispatchingfilter.DispatchingFilterTestCase;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DispatchingFilter
implements Filter {
    static ReadWriteLock rwLock = new ReentrantReadWriteLock();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        rwLock.writeLock().lock();
        try {
            if (req.getDispatcherType() != DispatcherType.FORWARD) {
                DispatchingFilterTestCase.readyToStop.setResult((Object)true);
                RequestDispatcher dispatcher = req.getServletContext().getRequestDispatcher("/path/servlet");
                dispatcher.forward(req, res);
            }
            chain.doFilter(req, res);
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }

    public void destroy() {
        rwLock.writeLock().lock();
        rwLock.writeLock().unlock();
    }
}

