/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.SecureCookieHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.handlers.MarkSecureHandler;
import io.undertow.servlet.test.handlers.IsSecureFilter;
import io.undertow.servlet.test.util.MessageServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class MarkSecureHandlerTestCase {
    public static final String HELLO_WORLD = "Hello World";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarkSecureHandler() throws IOException, GeneralSecurityException, ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("servlet", MessageServlet.class).addInitParam("message", HELLO_WORLD).addMapping("/issecure");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(MarkSecureHandlerTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlet(s);
        builder.addFilter(new FilterInfo("issecure-filter", IsSecureFilter.class));
        builder.addFilterUrlMapping("issecure-filter", "/*", DispatcherType.REQUEST);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)new MarkSecureHandler((HttpHandler)root));
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/issecure");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"true", (Object)result.getHeaders("issecure")[0].getValue());
            Header header = result.getFirstHeader("set-cookie");
            Assert.assertEquals((Object)"foo=bar", (Object)header.getValue());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)HELLO_WORLD, (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarkSecureHandlerWithSecureCookieHandler() throws IOException, GeneralSecurityException, ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("servlet", MessageServlet.class).addInitParam("message", HELLO_WORLD).addMapping("/issecure");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(MarkSecureHandlerTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlet(s);
        builder.addFilter(new FilterInfo("issecure-filter", IsSecureFilter.class));
        builder.addFilterUrlMapping("issecure-filter", "/*", DispatcherType.REQUEST);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)new MarkSecureHandler((HttpHandler)new SecureCookieHandler((HttpHandler)root)));
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/issecure");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"true", (Object)result.getHeaders("issecure")[0].getValue());
            Header header = result.getFirstHeader("set-cookie");
            Assert.assertEquals((Object)"foo=bar; secure", (Object)header.getValue());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)HELLO_WORLD, (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

