/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.listener.request.async.onError;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

public class SimpleAsyncListener
implements AsyncListener {
    public static final String MESSAGE = "handled by " + SimpleAsyncListener.class.getSimpleName();
    private final AsyncContext ctx;

    public SimpleAsyncListener() {
        this.ctx = null;
    }

    public SimpleAsyncListener(AsyncContext ctx) {
        this.ctx = ctx;
    }

    public void onComplete(AsyncEvent event) throws IOException {
    }

    public void onTimeout(AsyncEvent event) throws IOException {
    }

    public void onError(AsyncEvent event) throws IOException {
        ServletResponse response = event.getSuppliedResponse();
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setContentType("text/plain");
        httpResponse.setStatus(200);
        PrintWriter writer = httpResponse.getWriter();
        writer.write(MESSAGE);
        writer.flush();
        if (this.ctx != null) {
            this.ctx.complete();
        } else {
            event.getAsyncContext().complete();
        }
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
    }
}

