/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.multipart;

import io.undertow.util.FileUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.TreeSet;

public class MultiPartServlet
extends HttpServlet {
    private final boolean getParam;

    public MultiPartServlet() {
        this.getParam = false;
    }

    public MultiPartServlet(boolean getParam) {
        this.getParam = getParam;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            Collection parts = req.getParts();
            resp.setContentType("text/plain; charset=UTF-8");
            resp.setCharacterEncoding("UTF-8");
            PrintWriter writer = resp.getWriter();
            writer.println("PARAMS:");
            writer.println("parameter count: " + req.getParameterMap().size());
            writer.println("parameter name count: " + this.count(req.getParameterNames()));
            for (Part part : parts) {
                writer.println("name: " + part.getName());
                writer.println("filename: " + part.getSubmittedFileName());
                writer.println("content-type: " + part.getContentType());
                TreeSet headerNames = new TreeSet(part.getHeaderNames());
                for (String header : headerNames) {
                    writer.println(header + ": " + part.getHeader(header));
                    if (!header.equals("Content-Disposition")) continue;
                    String parameterValue = part.getHeader(header);
                    String parameterName = parameterValue.substring(parameterValue.indexOf("name=") + "name=\"".length());
                    String[] values = req.getParameterValues(parameterName = parameterName.substring(0, parameterName.indexOf(34)));
                    if (values == null) continue;
                    for (String value : values) {
                        writer.println("value: " + value);
                    }
                }
                writer.println("size: " + part.getSize());
                writer.println("content: " + FileUtils.readFile((InputStream)part.getInputStream()));
            }
            if (this.getParam) {
                Enumeration paramNames = req.getParameterNames();
                while (paramNames.hasMoreElements()) {
                    String name = (String)paramNames.nextElement();
                    writer.println("param name: " + name);
                    writer.println("param value: " + req.getParameter(name));
                }
            }
        }
        catch (Exception e) {
            resp.getWriter().write("EXCEPTION: " + e.getClass());
        }
    }

    private int count(Enumeration<String> parameterNames) {
        int count = 0;
        while (parameterNames.hasMoreElements()) {
            parameterNames.nextElement();
            ++count;
        }
        return count;
    }
}

