/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.protocol.cookie;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class CookieAssemblyTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("cookie-eater", CookieMuncher.class).addMapping("/");
        DeploymentInfo builder = new DeploymentInfo().setContextPath("/").setClassLoader(CookieAssemblyTestCase.class.getClassLoader()).setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("cookie-test1.war").addServlet(s);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicEncodingSelect() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet request = new HttpGet(DefaultServer.getDefaultServerURL() + "/cookie-test1");
            request.addHeader((Header)new BasicHeader("Cookie", "t1=munch"));
            request.addHeader((Header)new BasicHeader("Cookie", "t2=nom"));
            request.addHeader((Header)new BasicHeader("Cookie", "t3=gone"));
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() != 200) {
                Assert.fail((String)new BasicResponseHandler().handleResponse((HttpResponse)response));
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private static class CookieMuncher
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private CookieMuncher() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            Enumeration it = req.getHeaders("Cookie");
            int cookieHeadersCount = 0;
            StringBuffer sb = new StringBuffer();
            while (it.hasMoreElements()) {
                ++cookieHeadersCount;
                sb.append((String)it.nextElement()).append("\n");
            }
            if (cookieHeadersCount != 1) {
                resp.setStatus(500);
                resp.setContentType("text/plain");
                resp.getWriter().write("Too many cookie headers[" + cookieHeadersCount + "]: " + sb);
                resp.getWriter().flush();
                return;
            }
            Object[] cookies = req.getCookies();
            if (cookies.length != 3) {
                resp.setStatus(500);
                resp.setContentType("text/plain");
                resp.getWriter().write("Wrong number of Cookies[" + cookies.length + "]: " + Arrays.toString(cookies));
                resp.getWriter().flush();
                return;
            }
            resp.setStatus(200);
            resp.getWriter().flush();
        }
    }
}

