/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.constraint;

import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.test.security.constraint.AuthenticationMessageServlet;
import io.undertow.servlet.test.security.constraint.ServletIdentityManager;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class DenyUncoveredHttpMethodsTestCase {
    public static final String HELLO_WORLD = "Hello World";

    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("servlet", AuthenticationMessageServlet.class).addInitParam("message", HELLO_WORLD).addMapping("/vanilla").addMapping("/fully-covered").addMapping("/fully-covered-permit-no-role").addMapping("/fully-covered-deny-no-role").addMapping("/omitted-methods").addMapping("/omitted-methods-deny-empty-role");
        ServletIdentityManager identityManager = new ServletIdentityManager();
        identityManager.addUser("user", "password", "role");
        identityManager.addUser("unauthorized-user", "password", "unauthorized-role");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(DenyUncoveredHttpMethodsTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setIdentityManager((IdentityManager)identityManager).setLoginConfig(new LoginConfig("BASIC", "Test Realm")).addServlet(s);
        builder.setDenyUncoveredHttpMethods(true);
        builder.addSecurityConstraint((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/vanilla").addHttpMethod("GET").addHttpMethod("POST")).addRoleAllowed("role")).setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.PERMIT));
        builder.addSecurityConstraint((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/fully-covered")).addRoleAllowed("role"));
        builder.addSecurityConstraint((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/fully-covered-permit-no-role")).addRoleAllowed("role")).setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.PERMIT));
        builder.addSecurityConstraint((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/fully-covered-deny-no-role")).addRoleAllowed("role")).setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.DENY));
        builder.addSecurityConstraint((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/omitted-methods").addHttpMethodOmission("GET")).setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.PERMIT));
        builder.addSecurityConstraint((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/omitted-methods-deny-empty-role").addHttpMethodOmission("GET")).setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.DENY));
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    @Test
    public void testVanillaSecurityConstraint() throws IOException {
        TestHttpClient client = new TestHttpClient();
        String url = DefaultServer.getDefaultServerURL() + "/servletContext/vanilla";
        try {
            this.testAccessible(() -> new HttpGet(url), client, false);
            this.testAccessible(() -> new HttpPost(url), client, false);
            this.testForbidden(() -> new HttpPut(url), client);
            this.testForbidden(() -> new HttpDelete(url), client);
            this.testForbidden(() -> new HttpOptions(url), client);
            this.testForbidden(() -> new HttpTrace(url), client);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testFullyCoveredConstraint() throws IOException {
        TestHttpClient client = new TestHttpClient();
        String url = DefaultServer.getDefaultServerURL() + "/servletContext/fully-covered";
        try {
            this.testAccessible(() -> new HttpGet(url), client, false);
            this.testAccessible(() -> new HttpPost(url), client, false);
            this.testAccessible(() -> new HttpPut(url), client, false);
            this.testAccessible(() -> new HttpDelete(url), client, false);
            this.testAccessible(() -> new HttpOptions(url), client, false);
            this.testAccessible(() -> new HttpTrace(url), client, false);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testFullyCoveredPermitNoRoleConstraint() throws IOException {
        TestHttpClient client = new TestHttpClient();
        String url = DefaultServer.getDefaultServerURL() + "/servletContext/fully-covered-permit-no-role";
        try {
            this.testAccessible(() -> new HttpGet(url), client, false);
            this.testAccessible(() -> new HttpPost(url), client, false);
            this.testAccessible(() -> new HttpPut(url), client, false);
            this.testAccessible(() -> new HttpDelete(url), client, false);
            this.testAccessible(() -> new HttpOptions(url), client, false);
            this.testAccessible(() -> new HttpTrace(url), client, false);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testFullyCoveredDenyNoRoleConstraint() throws IOException {
        TestHttpClient client = new TestHttpClient();
        String url = DefaultServer.getDefaultServerURL() + "/servletContext/fully-covered-deny-no-role";
        try {
            this.testAccessible(() -> new HttpGet(url), client, false);
            this.testAccessible(() -> new HttpPost(url), client, false);
            this.testAccessible(() -> new HttpPut(url), client, false);
            this.testAccessible(() -> new HttpDelete(url), client, false);
            this.testAccessible(() -> new HttpOptions(url), client, false);
            this.testAccessible(() -> new HttpTrace(url), client, false);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testOmittedMethods() throws IOException {
        TestHttpClient client = new TestHttpClient();
        String url = DefaultServer.getDefaultServerURL() + "/servletContext/omitted-methods";
        try {
            this.testForbidden(() -> new HttpGet(url), client);
            this.testAccessible(() -> new HttpPost(url), client, true);
            this.testAccessible(() -> new HttpPut(url), client, true);
            this.testAccessible(() -> new HttpDelete(url), client, true);
            this.testAccessible(() -> new HttpOptions(url), client, true);
            this.testAccessible(() -> new HttpTrace(url), client, true);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testOmittedMethodsDenyEmptyRole() throws IOException {
        TestHttpClient client = new TestHttpClient();
        String url = DefaultServer.getDefaultServerURL() + "/servletContext/omitted-methods-deny-empty-role";
        try {
            this.testForbidden(() -> new HttpGet(url), client);
            this.testForbidden(() -> new HttpPost(url), client);
            this.testForbidden(() -> new HttpPut(url), client);
            this.testForbidden(() -> new HttpDelete(url), client);
            this.testForbidden(() -> new HttpOptions(url), client);
            this.testForbidden(() -> new HttpTrace(url), client);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    public void testAccessible(Supplier<HttpRequestBase> newRequest, TestHttpClient client, boolean noRolePermitted) throws IOException {
        HttpRequestBase request = newRequest.get();
        request.addHeader("ExpectedMechanism", "None");
        request.addHeader("ExpectedUser", "None");
        CloseableHttpResponse result = client.execute((HttpUriRequest)request);
        if (noRolePermitted) {
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        } else {
            Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
            Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
            Assert.assertEquals((long)1L, (long)values.length);
            Assert.assertEquals((Object)(Headers.BASIC + " realm=\"Test Realm\""), (Object)values[0].getValue());
        }
        HttpClientUtils.readResponse((HttpResponse)result);
        request = newRequest.get();
        request.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"user:password".getBytes(), (boolean)false));
        request.addHeader("ExpectedMechanism", "BASIC");
        request.addHeader("ExpectedUser", "user");
        result = client.execute((HttpUriRequest)request);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        String response = HttpClientUtils.readResponse((HttpResponse)result);
        Assert.assertEquals((Object)HELLO_WORLD, (Object)response);
        request = newRequest.get();
        request.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"unauthorized-user:password".getBytes(), (boolean)false));
        request.addHeader("ExpectedMechanism", "BASIC");
        request.addHeader("ExpectedUser", "unauthorized-user");
        result = client.execute((HttpUriRequest)request);
        if (noRolePermitted) {
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)HELLO_WORLD, (Object)response);
        } else {
            Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
    }

    public void testForbidden(Supplier<HttpRequestBase> newRequest, TestHttpClient client) throws IOException {
        HttpRequestBase request = newRequest.get();
        CloseableHttpResponse result = client.execute((HttpUriRequest)request);
        Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)0L, (long)values.length);
        HttpClientUtils.readResponse((HttpResponse)result);
        request = newRequest.get();
        request.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"user:password".getBytes(), (boolean)false));
        request.addHeader("ExpectedMechanism", "BASIC");
        request.addHeader("ExpectedUser", "user");
        result = client.execute((HttpUriRequest)request);
        Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
        values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)0L, (long)values.length);
        HttpClientUtils.readResponse((HttpResponse)result);
        request = newRequest.get();
        request.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"unauthorized-user:password".getBytes(), (boolean)false));
        request.addHeader("ExpectedMechanism", "BASIC");
        request.addHeader("ExpectedUser", "user");
        result = client.execute((HttpUriRequest)request);
        Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
        values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)0L, (long)values.length);
        HttpClientUtils.readResponse((HttpResponse)result);
    }
}

