/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.streams;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class AsyncInputStreamServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int preamble = Math.max(0, req.getIntHeader("preamble"));
        boolean offIoThread = req.getHeader("offIoThread") != null;
        AsyncContext context = req.startAsync();
        context.setTimeout(60000L);
        ServletOutputStream outputStream = resp.getOutputStream();
        ServletInputStream inputStream = req.getInputStream();
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        for (int i = 0; i < preamble; ++i) {
            int value = inputStream.read();
            assert (value >= 0) : "Stream is finished";
            data.write(value);
        }
        MyListener listener = new MyListener(outputStream, inputStream, data, context, offIoThread);
        inputStream.setReadListener((ReadListener)listener);
        if (!offIoThread) {
            outputStream.setWriteListener((WriteListener)listener);
        }
    }

    private class MyListener
    implements WriteListener,
    ReadListener {
        private final ServletOutputStream outputStream;
        private final ServletInputStream inputStream;
        private final ByteArrayOutputStream dataToWrite;
        private final AsyncContext context;
        private final boolean offIoThread;
        boolean done = false;
        int written = 0;

        MyListener(ServletOutputStream outputStream, ServletInputStream inputStream, ByteArrayOutputStream dataToWrite, AsyncContext context, boolean offIoThread) {
            this.outputStream = outputStream;
            this.inputStream = inputStream;
            this.dataToWrite = dataToWrite;
            this.context = context;
            this.offIoThread = offIoThread;
        }

        public void onWritePossible() throws IOException {
            if (this.offIoThread || this.outputStream.isReady()) {
                this.dataToWrite.writeTo((OutputStream)this.outputStream);
                this.written += this.dataToWrite.size();
                this.dataToWrite.reset();
                if (this.done) {
                    this.context.complete();
                }
            }
        }

        public void onDataAvailable() throws IOException {
            if (this.offIoThread) {
                this.context.start(new Runnable(){

                    @Override
                    public void run() {
                        MyListener.this.doOnDataAvailable();
                    }
                });
            } else {
                this.doOnDataAvailable();
            }
        }

        private void doOnDataAvailable() {
            try {
                while (this.inputStream.isReady()) {
                    int read = this.inputStream.read();
                    if (read == 0) {
                        System.out.println("onDataAvailable> read 0x00");
                    }
                    if (read != -1) {
                        this.dataToWrite.write(read);
                        continue;
                    }
                    this.onWritePossible();
                }
            }
            catch (IOException e) {
                this.context.complete();
                throw new RuntimeException(e);
            }
        }

        public synchronized void onAllDataRead() throws IOException {
            this.done = true;
            if (this.offIoThread) {
                this.context.start(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MyListener.this.onWritePossible();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                this.onWritePossible();
            }
        }

        public synchronized void onError(Throwable t) {
            t.printStackTrace();
        }
    }
}

