/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.async;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SimpleDateThreadLocalAsyncServlet
extends HttpServlet {
    public static final String NULL_THREAD_LOCAL = "NULL_THREAD_LOCAL";
    private static final String DATE_FORMAT = "yyyyMMddHHmmssSSSZ";
    private static final ThreadLocal<Date> simpleDateThreadLocal = new ThreadLocal();

    public static Date getThreadLocalSimpleDate() {
        return simpleDateThreadLocal.get();
    }

    public static void initThreadLocalSimpleDate() {
        simpleDateThreadLocal.set(new Date());
    }

    public static void removeThreadLocalSimpleDate() {
        simpleDateThreadLocal.remove();
    }

    public static Date parseDate(String date) throws ParseException {
        return new SimpleDateFormat(DATE_FORMAT).parse(date);
    }

    public static String formatDate(Date date) {
        return new SimpleDateFormat(DATE_FORMAT).format(date);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext ac = request.startAsync((ServletRequest)request, (ServletResponse)response);
        ac.start(() -> {
            try {
                response.setStatus(200);
                Date date = SimpleDateThreadLocalAsyncServlet.getThreadLocalSimpleDate();
                try (PrintWriter pw = response.getWriter();){
                    pw.write(date == null ? NULL_THREAD_LOCAL : SimpleDateThreadLocalAsyncServlet.formatDate(date));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

