/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.handlers;

import io.undertow.servlet.Servlets;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class AbstractHttpContinueServletTestCase {
    private static volatile boolean accept = false;

    @BeforeClass
    public static void setup() {
        DeploymentUtils.setupServlet(Servlets.servlet(ContinueConsumeServlet.class).addMappings(new String[]{"/path"}), Servlets.servlet(ContinueIgnoreServlet.class).addMappings(new String[]{"/ignore"}));
    }

    @Before
    public void before() throws Exception {
        Assume.assumeFalse((boolean)DefaultServer.isAjp());
    }

    protected abstract String getServerAddress();

    protected abstract TestHttpClient getClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpContinueRejected() throws IOException {
        accept = false;
        String message = "My HTTP Request!";
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setParameter("http.protocol.wait-for-continue", (Object)Integer.MAX_VALUE);
        TestHttpClient client = this.getClient();
        client.setParams((HttpParams)httpParams);
        try {
            HttpPost post = new HttpPost(this.getServerAddress() + "/servletContext/path");
            post.addHeader("Expect", "100-continue");
            post.setEntity((HttpEntity)new StringEntity(message));
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)417L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpContinueAccepted() throws IOException {
        accept = true;
        String message = "My HTTP Request!";
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setParameter("http.protocol.wait-for-continue", (Object)Integer.MAX_VALUE);
        TestHttpClient client = this.getClient();
        client.setParams((HttpParams)httpParams);
        try {
            HttpPost post = new HttpPost(this.getServerAddress() + "/servletContext/path");
            post.addHeader("Expect", "100-continue");
            post.setEntity((HttpEntity)new StringEntity(message));
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)message, (Object)HttpClientUtils.readResponse((HttpResponse)result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpContinueIgnored() throws IOException {
        accept = true;
        String message = "My HTTP Request!";
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setParameter("http.protocol.wait-for-continue", (Object)Integer.MAX_VALUE);
        TestHttpClient client = this.getClient();
        client.setParams((HttpParams)httpParams);
        try {
            HttpPost post = new HttpPost(this.getServerAddress() + "/servletContext/ignore");
            post.addHeader("Expect", "100-continue");
            post.setEntity((HttpEntity)new StringEntity(message));
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"", (Object)HttpClientUtils.readResponse((HttpResponse)result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyHttpContinue() throws IOException {
        accept = true;
        String message = "My HTTP Request!";
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setParameter("http.protocol.wait-for-continue", (Object)Integer.MAX_VALUE);
        TestHttpClient client = this.getClient();
        client.setParams((HttpParams)httpParams);
        try {
            HttpGet post = new HttpGet(this.getServerAddress() + "/servletContext/ignore");
            post.addHeader("Expect", "100-continue");
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"", (Object)HttpClientUtils.readResponse((HttpResponse)result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpContinueAcceptedWithChunkedRequest() throws IOException {
        accept = true;
        String message = "My HTTP Request!";
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setParameter("http.protocol.wait-for-continue", (Object)Integer.MAX_VALUE);
        TestHttpClient client = this.getClient();
        client.setParams((HttpParams)httpParams);
        try {
            HttpPost post = new HttpPost(this.getServerAddress() + "/servletContext/path");
            post.addHeader("Expect", "100-continue");
            post.setEntity((HttpEntity)new StringEntity(message){

                public long getContentLength() {
                    return -1L;
                }
            });
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)message, (Object)HttpClientUtils.readResponse((HttpResponse)result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    public static class ContinueIgnoreServlet
    extends HttpServlet {
        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        }
    }

    public static class ContinueConsumeServlet
    extends HttpServlet {
        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            try {
                if (!accept) {
                    resp.setStatus(417);
                    return;
                }
                byte[] buffer = new byte[1024];
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                int r = 0;
                ServletOutputStream outputStream = resp.getOutputStream();
                ServletInputStream inputStream = req.getInputStream();
                while ((r = inputStream.read(buffer)) > 0) {
                    b.write(buffer, 0, r);
                }
                outputStream.write(b.toByteArray());
                outputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

