/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.multipart;

import io.undertow.util.FileUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.TreeSet;

public class MultiPartServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            Collection parts = req.getParts();
            resp.setContentType("text/plain; charset=UTF-8");
            resp.setCharacterEncoding("UTF-8");
            PrintWriter writer = resp.getWriter();
            writer.println("PARAMS:");
            writer.println("parameter count: " + req.getParameterMap().size());
            writer.println("parameter name count: " + this.count(req.getParameterNames()));
            for (Part part : parts) {
                writer.println("name: " + part.getName());
                writer.println("filename: " + part.getSubmittedFileName());
                writer.println("content-type: " + part.getContentType());
                TreeSet headerNames = new TreeSet(part.getHeaderNames());
                for (String header : headerNames) {
                    writer.println(header + ": " + part.getHeader(header));
                }
                writer.println("size: " + part.getSize());
                writer.println("content: " + FileUtils.readFile((InputStream)part.getInputStream()));
            }
        }
        catch (Exception e) {
            resp.getWriter().write("EXCEPTION: " + e.getClass());
        }
    }

    private int count(Enumeration<String> parameterNames) {
        int count = 0;
        while (parameterNames.hasMoreElements()) {
            parameterNames.nextElement();
            ++count;
        }
        return count;
    }
}

