/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.multipart;

import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ExceptionHandler;
import io.undertow.servlet.api.LoggingExceptionHandler;
import io.undertow.servlet.test.multipart.AddMultipartServetListener;
import io.undertow.servlet.test.multipart.MultiPartServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@ProxyIgnore
public class MultiPartTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        DeploymentUtils.setupServlet(new ServletExtension(){

            public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
                deploymentInfo.addListener(Servlets.listener(AddMultipartServetListener.class));
                deploymentInfo.setExceptionHandler((ExceptionHandler)LoggingExceptionHandler.builder().add(RuntimeException.class, "io.undertow", Logger.Level.DEBUG).build());
            }
        }, Servlets.servlet((String)"mp0", MultiPartServlet.class).addMapping("/0"), Servlets.servlet((String)"mp1", MultiPartServlet.class).addMapping("/1").setMultipartConfig(Servlets.multipartConfig(null, (long)0L, (long)0L, (int)0)), Servlets.servlet((String)"mp2", MultiPartServlet.class).addMapping("/2").setMultipartConfig(Servlets.multipartConfig(null, (long)0L, (long)3L, (int)0)), Servlets.servlet((String)"mp3", MultiPartServlet.class).addMapping("/3").setMultipartConfig(Servlets.multipartConfig(null, (long)3L, (long)0L, (int)0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiPartRequestWithNoMultipartConfig() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            String uri = DefaultServer.getDefaultServerURL() + "/servletContext/0";
            HttpPost post = new HttpPost(uri);
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("formValue", (ContentBody)new StringBody("myValue", "text/plain", StandardCharsets.UTF_8));
            entity.addPart("file", (ContentBody)new FileBody(new File(MultiPartTestCase.class.getResource("uploadfile.txt").getFile())));
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"EXCEPTION: class java.lang.IllegalStateException", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiPartRequest() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            String uri = DefaultServer.getDefaultServerURL() + "/servletContext/1";
            HttpPost post = new HttpPost(uri);
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, null, StandardCharsets.UTF_8);
            entity.addPart("formValue", (ContentBody)new StringBody("myValue", "text/plain", StandardCharsets.UTF_8));
            entity.addPart("file", (ContentBody)new FileBody(new File(MultiPartTestCase.class.getResource("uploadfile.txt").getFile())));
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"PARAMS:\r\nparameter count: 1\r\nparameter name count: 1\r\nname: formValue\r\nfilename: null\r\ncontent-type: null\r\nContent-Disposition: form-data; name=\"formValue\"\r\nsize: 7\r\ncontent: myValue\r\nname: file\r\nfilename: uploadfile.txt\r\ncontent-type: application/octet-stream\r\nContent-Disposition: form-data; name=\"file\"; filename=\"uploadfile.txt\"\r\nContent-Type: application/octet-stream\r\nsize: 13\r\ncontent: file contents\r\n", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiPartRequestWithAddedServlet() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            String uri = DefaultServer.getDefaultServerURL() + "/servletContext/added";
            HttpPost post = new HttpPost(uri);
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("formValue", (ContentBody)new StringBody("myValue", "text/plain", StandardCharsets.UTF_8));
            entity.addPart("file", (ContentBody)new FileBody(new File(MultiPartTestCase.class.getResource("uploadfile.txt").getFile())));
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"PARAMS:\r\nparameter count: 1\r\nparameter name count: 1\r\nname: formValue\r\nfilename: null\r\ncontent-type: null\r\nContent-Disposition: form-data; name=\"formValue\"\r\nsize: 7\r\ncontent: myValue\r\nname: file\r\nfilename: uploadfile.txt\r\ncontent-type: application/octet-stream\r\nContent-Disposition: form-data; name=\"file\"; filename=\"uploadfile.txt\"\r\nContent-Type: application/octet-stream\r\nsize: 13\r\ncontent: file contents\r\n", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiPartRequestToLarge() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            String uri = DefaultServer.getDefaultServerURL() + "/servletContext/2";
            HttpPost post = new HttpPost(uri);
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("formValue", (ContentBody)new StringBody("myValue", "text/plain", StandardCharsets.UTF_8));
            entity.addPart("file", (ContentBody)new FileBody(new File(MultiPartTestCase.class.getResource("uploadfile.txt").getFile())));
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"EXCEPTION: class java.lang.IllegalStateException", (Object)response);
        }
        catch (IOException iOException) {
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiPartIndividualFileToLarge() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            String uri = DefaultServer.getDefaultServerURL() + "/servletContext/3";
            HttpPost post = new HttpPost(uri);
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("formValue", (ContentBody)new StringBody("myValue", "text/plain", StandardCharsets.UTF_8));
            entity.addPart("file", (ContentBody)new FileBody(new File(MultiPartTestCase.class.getResource("uploadfile.txt").getFile())));
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"EXCEPTION: class java.lang.IllegalStateException", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiPartRequestUtf8CharsetInPart() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            String uri = DefaultServer.getDefaultServerURL() + "/servletContext/1";
            HttpPost post = new HttpPost(uri);
            MultipartEntity entity = new MultipartEntity();
            entity.addPart("formValue", (ContentBody)new StringBody("myValue\u00e5", ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8)));
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"PARAMS:\r\nparameter count: 1\r\nparameter name count: 1\r\nname: formValue\r\nfilename: null\r\ncontent-type: text/plain; charset=UTF-8\r\nContent-Disposition: form-data; name=\"formValue\"\r\nContent-Transfer-Encoding: 8bit\r\nContent-Type: text/plain; charset=UTF-8\r\nsize: 9\r\ncontent: myValue\u00e5\r\n", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

