/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.request;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.request.RequestHostValuesServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class HttpHostValuesTestCase {
    @BeforeClass
    public static void setup() {
        PathHandler pathHandler = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(HttpHostValuesTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlets(new ServletInfo[]{Servlets.servlet((String)"request", RequestHostValuesServlet.class).addMapping("/")});
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        try {
            pathHandler.addPrefixPath(builder.getContextPath(), manager.start());
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        DefaultServer.setRootHandler((HttpHandler)pathHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestSpec() throws Exception {
        try (TestHttpClient client = new TestHttpClient();){
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            if (System.getProperty("os.name").toLowerCase().contains("windows") || System.getSecurityManager() != null) {
                Assert.assertTrue((String)String.format("hostName: %s , response: %s", DefaultServer.getDefaultServerAddress().toString(), response), (boolean)DefaultServer.getDefaultServerAddress().toString().contains(response));
            } else {
                Assert.assertTrue((String)String.format("hostName: %s , response: %s", DefaultServer.getHostAddress(), response), (boolean)DefaultServer.getHostAddress().equals(response));
            }
        }
    }
}

