/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.ssl;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.cert.X509Certificate;

@ServletSecurity(value=@HttpConstraint)
public class SSLAttributesServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter pw = resp.getWriter();
        if (req.getServletPath().equals("/id")) {
            pw.write(req.getAttribute("jakarta.servlet.request.ssl_session_id").toString());
        } else if (req.getServletPath().equals("/key-size")) {
            pw.write(req.getAttribute("jakarta.servlet.request.key_size").toString());
        } else if (req.getServletPath().equals("/cipher-suite")) {
            pw.write(req.getAttribute("jakarta.servlet.request.cipher_suite").toString());
        } else if (req.getServletPath().equals("/cert")) {
            X509Certificate[] attribute = (X509Certificate[])req.getAttribute("jakarta.servlet.request.X509Certificate");
            if (attribute != null) {
                pw.write(attribute[0].getSerialNumber().toString());
            }
        } else if (req.getServletPath().equals("/cert-dn")) {
            X509Certificate[] attribute = (X509Certificate[])req.getAttribute("jakarta.servlet.request.X509Certificate");
            pw.write(attribute != null && attribute.length > 0 ? attribute[0].getSubjectDN().toString() : "null");
        }
        pw.close();
    }
}

