/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.streams;

import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.streams.AbstractServletInputStreamTestCase;
import io.undertow.servlet.test.streams.AsyncInputStreamServlet;
import io.undertow.servlet.test.streams.BlockingInputStreamServlet;
import io.undertow.servlet.test.streams.EagerAsyncInputStreamServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletInputStreamTestCase
extends AbstractServletInputStreamTestCase {
    @BeforeClass
    public static void setup() {
        DeploymentUtils.setupServlet(new ServletInfo("blockingInput", BlockingInputStreamServlet.class).addMapping("/blockingInput"), new ServletInfo("asyncInput", AsyncInputStreamServlet.class).addMapping("/asyncInput").setAsyncSupported(true), new ServletInfo("asyncEagerInput", EagerAsyncInputStreamServlet.class).addMapping("/asyncEagerInput").setAsyncSupported(true));
    }

    @Test
    public void testAsyncServletInputStreamEagerIsReady() {
        StringBuilder builder = new StringBuilder(1000 * "Hello World".length());
        for (int i = 0; i < 10; ++i) {
            try {
                for (int j = 0; j < 10000; ++j) {
                    builder.append("Hello World");
                }
                String message = builder.toString();
                this.runTest(message, "asyncEagerInput", false, false);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("test failed with i equal to " + i, e);
            }
        }
    }

    @Override
    @Test
    @Ignore(value="UNDERTOW-1927 503 result received sporadically")
    public void testAsyncServletInputStreamInParallelOffIoThread() {
    }

    @Override
    @Test
    @Ignore(value="UNDERTOW-1927 503 result received sporadically")
    public void testAsyncServletInputStreamInParallel() {
    }
}

