/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.charset;

import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.test.charset.DefaultCharsetFormParserServlet;
import io.undertow.servlet.test.charset.DefaultCharsetServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Collections;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class DefaultCharsetTestCase {
    private static final byte[] UTF8 = DefaultCharsetTestCase.toByteArray(new int[]{65, 194, 169, 195, 169, 204, 129, 224, 165, 129, 240, 157, 148, 138});

    @BeforeClass
    public static void setup() throws ServletException {
        DeploymentUtils.setupServlet(new ServletExtension(){

            public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
                deploymentInfo.setDefaultEncoding("UTF-8");
            }
        }, Servlets.servlet((String)"servlet", DefaultCharsetServlet.class).addMapping("/writer"), Servlets.servlet((String)"form", DefaultCharsetFormParserServlet.class).addMapping("/form"));
    }

    public static byte[] toByteArray(int[] source) {
        byte[] ret = new byte[source.length];
        for (int i = 0; i < source.length; ++i) {
            ret[i] = (byte)(0xFF & source[i]);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCharacterEncodingWriter() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/writer");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            byte[] response = HttpClientUtils.readRawResponse((HttpResponse)result);
            Assert.assertArrayEquals((byte[])UTF8, (byte[])response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/writer?array=true");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readRawResponse((HttpResponse)result);
            Assert.assertArrayEquals((byte[])UTF8, (byte[])response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCharacterEncodingFormParser() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/servletContext/form");
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(Collections.singletonList(new BasicNameValuePair("A\u00a9\u00e9\u0301\u0941\ud835\udd0a", "A\u00a9\u00e9\u0301\u0941\ud835\udd0a")), "UTF-8"));
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            byte[] response = HttpClientUtils.readRawResponse((HttpResponse)result);
            Assert.assertArrayEquals((byte[])UTF8, (byte[])response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

