/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.dispatcher;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.accesslog.AccessLogFileTestCase;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.dispatcher.DispatcherForwardServlet;
import io.undertow.servlet.test.dispatcher.ForwardPathTestServlet;
import io.undertow.servlet.test.dispatcher.ForwardServlet;
import io.undertow.servlet.test.dispatcher.NextServlet;
import io.undertow.servlet.test.dispatcher.util.DispatcherUtil;
import io.undertow.servlet.test.util.MessageFilter;
import io.undertow.servlet.test.util.MessageServlet;
import io.undertow.servlet.test.util.ParameterEchoServlet;
import io.undertow.servlet.test.util.PathTestServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class DispatcherForwardTestCase {
    private static volatile String message;
    private static volatile CountDownLatch latch;
    private static final AccessLogReceiver RECEIVER;

    @BeforeClass
    public static void setup() throws ServletException {
        Assume.assumeFalse((boolean)DefaultServer.isH2upgrade());
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setResourceManager((ResourceManager)new TestResourceLoader(DispatcherForwardTestCase.class)).addServlet(new ServletInfo("forward", MessageServlet.class).addInitParam("message", "forwarded").addMapping("/forward")).addServlet(new ServletInfo("dispatcher", ForwardServlet.class).addMapping("/dispatch").addMapping("/dispatch/*").addMapping("*.dispatch")).addServlet(new ServletInfo("pathTest", PathTestServlet.class).addMapping("/path")).addServlet(new ServletInfo("pathForwardTest", ForwardPathTestServlet.class).addMapping("/path-forward").addMapping("/path-forward/*").addMapping("*.forwardinfo")).addServlet(new ServletInfo("parameterEcho", ParameterEchoServlet.class).addMapping("/echo-parameters")).addServlet(new ServletInfo("/dispatchServlet", DispatcherForwardServlet.class).addMapping("/dispatchServlet")).addServlet(new ServletInfo("/next", NextServlet.class).addMapping("/next")).addFilter(new FilterInfo("notforwarded", MessageFilter.class).addInitParam("message", "Not forwarded")).addFilter(new FilterInfo("inc", MessageFilter.class).addInitParam("message", "Path!")).addFilter(new FilterInfo("nameFilter", MessageFilter.class).addInitParam("message", "Name!")).addFilterUrlMapping("notforwarded", "/forward", DispatcherType.REQUEST).addFilterUrlMapping("inc", "/forward", DispatcherType.FORWARD).addFilterServletNameMapping("nameFilter", "forward", DispatcherType.FORWARD);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)new AccessLogHandler((HttpHandler)root, RECEIVER, "%r %U %R", AccessLogFileTestCase.class.getClassLoader()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPathBasedInclude() throws IOException, InterruptedException {
        this.resetLatch();
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch");
            get.setHeader("forward", "/forward");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Path!Name!forwarded", (Object)response);
            latch.await(30L, TimeUnit.SECONDS);
            String protocol = DefaultServer.isH2() ? "HTTP/2.0" : "HTTP/1.1";
            Assert.assertEquals((Object)("GET /servletContext/dispatch " + protocol + " /servletContext/dispatch /dispatch"), (Object)message);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private void resetLatch() {
        latch.countDown();
        latch = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameBasedInclude() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch");
            get.setHeader("forward", "forward");
            get.setHeader("name", "true");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Name!forwarded", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameBasedForwardOutServletContext() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch");
            get.setHeader("forward", "../forward");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)500L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"dispatcher was null!"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPathBasedStaticInclude() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch");
            get.setHeader("forward", "/snippet.html");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"SnippetText", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPathBasedStaticIncludePost() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch");
            post.setHeader("forward", "/snippet.html");
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"SnippetText", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncludeAggregatesQueryString() throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        String protocol = DefaultServer.isH2() ? "HTTP/2.0" : "HTTP/1.1";
        try {
            this.resetLatch();
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch?a=b");
            get.setHeader("forward", "/path");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"pathInfo:null queryString:a=b servletPath:/path requestUri:/servletContext/path", (Object)response);
            latch.await(30L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)("GET /servletContext/dispatch?a=b " + protocol + " /servletContext/dispatch /dispatch"), (Object)message);
            this.resetLatch();
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch?a=b");
            get.setHeader("forward", "/path?foo=bar");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"pathInfo:null queryString:foo=bar servletPath:/path requestUri:/servletContext/path", (Object)response);
            latch.await(30L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)("GET /servletContext/dispatch?a=b " + protocol + " /servletContext/dispatch /dispatch"), (Object)message);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncludesPathParameters() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch?a=b");
            get.setHeader("forward", "/path;pathparam=foo");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"pathInfo:null queryString:a=b servletPath:/path requestUri:/servletContext/path;pathparam=foo", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncludesUrlInPathParameters() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch");
            get.setHeader("forward", "/path?url=http://test.com");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"pathInfo:null queryString:url=http://test.com servletPath:/path requestUri:/servletContext/path", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttributes() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch?n1=v1&n2=v2");
            get.setHeader("forward", "/path-forward");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"pathInfo:null queryString:n1=v1&n2=v2 servletPath:/path-forward requestUri:/servletContext/path-forward\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.request_uri:/servletContext/dispatch\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.context_path:/servletContext\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.servlet_path:/dispatch\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.path_info:null\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.query_string:n1=v1&n2=v2\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.mapping:"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttributesEncoded() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch/dispatch%25info?n1=v%251&n2=v%252");
            get.setHeader("forward", "/path-forward/path%25info?n3=V%253");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"pathInfo:/path%info queryString:n3=V%253 servletPath:/path-forward requestUri:/servletContext/path-forward/path%25info\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.request_uri:/servletContext/dispatch/dispatch%25info\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.context_path:/servletContext\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.servlet_path:/dispatch\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.path_info:/dispatch%info\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.query_string:n1=v%251&n2=v%252\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.mapping:"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttributesEncodedExtension() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dis%25patch/dispatch%25info.dispatch?n1=v%251&n2=v%252");
            get.setHeader("forward", "/to%25forward/path%25info.forwardinfo?n3=V%253");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"pathInfo:null queryString:n3=V%253 servletPath:/to%forward/path%info.forwardinfo requestUri:/servletContext/to%25forward/path%25info.forwardinfo\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.request_uri:/servletContext/dis%25patch/dispatch%25info.dispatch\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.context_path:/servletContext\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.servlet_path:/dis%patch/dispatch%info.dispatch\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.path_info:null\r\n"));
            MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"jakarta.servlet.forward.query_string:n1=v%251&n2=v%252\r\n"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParametersAreMerged() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch?param1=v11&param1=v12");
            get.setHeader("forward", "/echo-parameters?param1=v13&param1=v14");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"param1='v13,v14,v11,v12'", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParametersAreMergedButNotDuplicated() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch?param1=v11&param1=v12");
            get.setHeader("forward", "/echo-parameters?param1=v11&param1=v13&param1=v14");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"param1='v11,v13,v14,v12'", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisptacherServletForward() throws IOException, InterruptedException {
        this.resetLatch();
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatchServlet");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            org.wildfly.common.Assert.assertTrue((boolean)DispatcherUtil.containsWord(response, "jakarta.servlet.forward.context_path"));
            org.wildfly.common.Assert.assertTrue((boolean)DispatcherUtil.containsWord(response, "jakarta.servlet.forward.servlet_path"));
            org.wildfly.common.Assert.assertTrue((boolean)DispatcherUtil.containsWord(response, "jakarta.servlet.forward.request_uri"));
            org.wildfly.common.Assert.assertTrue((boolean)DispatcherUtil.containsWord(response, "jakarta.servlet.forward.mapping"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    static {
        latch = new CountDownLatch(1);
        RECEIVER = new AccessLogReceiver(){

            public void logMessage(String msg) {
                message = msg;
                latch.countDown();
            }
        };
    }
}

