/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.listener.request.async.onTimeout;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.listener.request.async.onTimeout.AsyncServlet;
import io.undertow.servlet.test.listener.request.async.onTimeout.SimpleRequestListener;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletException;
import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class NestedListenerInvocationTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo a = new ServletInfo("asyncServlet", AsyncServlet.class).setAsyncSupported(true).addMapping("/async");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(NestedListenerInvocationTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlets(new ServletInfo[]{a}).addListener(new ListenerInfo(SimpleRequestListener.class));
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleHttpServlet() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/async");
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Assert.assertFalse((boolean)SimpleRequestListener.hasNestedInvocationOccured());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

