/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.redirect;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.redirect.RedirectWithContentLengthServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class RedirectWithContentLengthTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler pathHandler = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(RedirectWithContentLengthTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlets(new ServletInfo[]{Servlets.servlet((String)"redirect", RedirectWithContentLengthServlet.class).addMapping("/redirect/*")});
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        pathHandler.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)pathHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServletRedirect() throws Exception {
        String requestURL = DefaultServer.getDefaultServerURL() + "/servletContext/redirect/";
        String expectedBody = "/servletContext/redirect/subpath";
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(requestURL);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"/servletContext/redirect/subpath", (Object)response);
            Header[] header = result.getHeaders("Content-Length");
            Assert.assertEquals((long)1L, (long)header.length);
            Assert.assertEquals((long)"/servletContext/redirect/subpath".length(), (long)Integer.valueOf(header[0].getValue()).intValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testServletRedirectNoFollow() throws Exception {
        String requestURL = DefaultServer.getDefaultServerURL() + "/servletContext/redirect/";
        String expectedRedirect = DefaultServer.getDefaultServerURL() + "/servletContext/redirect/subpath";
        try (CloseableHttpClient client = HttpClientBuilder.create().disableRedirectHandling().build();){
            HttpGet get = new HttpGet(requestURL);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)302L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"", (Object)HttpClientUtils.readResponse((HttpResponse)result));
            Header[] header = result.getHeaders("Content-Length");
            Assert.assertEquals((long)1L, (long)header.length);
            Assert.assertEquals((long)0L, (long)Integer.parseInt(header[0].getValue()));
            header = result.getHeaders("Location");
            Assert.assertEquals((long)1L, (long)header.length);
            Assert.assertEquals((Object)expectedRedirect, (Object)header[0].getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testServletRedirectHead() throws Exception {
        String requestURL = DefaultServer.getDefaultServerURL() + "/servletContext/redirect/";
        String expectedBody = "/servletContext/redirect/subpath";
        TestHttpClient client = new TestHttpClient();
        try {
            HttpHead head = new HttpHead(requestURL);
            CloseableHttpResponse result = client.execute((HttpUriRequest)head);
            Assert.assertEquals((Object)"", (Object)HttpClientUtils.readResponse((HttpResponse)result));
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header[] header = result.getHeaders("Content-Length");
            Assert.assertEquals((long)1L, (long)header.length);
            Assert.assertEquals((long)"/servletContext/redirect/subpath".length(), (long)Integer.parseInt(header[0].getValue()));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testServletRedirectHeadNoFollow() throws Exception {
        String requestURL = DefaultServer.getDefaultServerURL() + "/servletContext/redirect/";
        String expectedRedirect = DefaultServer.getDefaultServerURL() + "/servletContext/redirect/subpath";
        try (CloseableHttpClient client = HttpClientBuilder.create().disableRedirectHandling().build();){
            HttpHead head = new HttpHead(requestURL);
            CloseableHttpResponse result = client.execute((HttpUriRequest)head);
            Assert.assertEquals((long)302L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"", (Object)HttpClientUtils.readResponse((HttpResponse)result));
            Header[] header = result.getHeaders("Content-Length");
            Assert.assertEquals((long)1L, (long)header.length);
            Assert.assertEquals((long)0L, (long)Integer.parseInt(header[0].getValue()));
            header = result.getHeaders("Location");
            Assert.assertEquals((long)1L, (long)header.length);
            Assert.assertEquals((Object)expectedRedirect, (Object)header[0].getValue());
        }
    }
}

