/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.upgrade;

import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.upgrade.AsyncUpgradeServlet;
import io.undertow.servlet.test.upgrade.UpgradeServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@HttpOneOnly
@RunWith(value=DefaultServer.class)
public class SimpleUpgradeTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        DeploymentUtils.setupServlet(new ServletInfo("upgradeServlet", UpgradeServlet.class).addMapping("/upgrade"), new ServletInfo("upgradeAsyncServlet", AsyncUpgradeServlet.class).addMapping("/asyncupgrade"));
    }

    @Test
    public void testBlockingUpgrade() throws IOException {
        this.runTest("/servletContext/upgrade");
    }

    @Test
    public void testAsyncUpgrade() throws IOException {
        this.runTest("/servletContext/asyncupgrade");
    }

    public void runTest(String url) throws IOException {
        Socket socket = new Socket(DefaultServer.getHostAddress((String)"default"), DefaultServer.getHostPort((String)"default"));
        InputStream in = socket.getInputStream();
        OutputStream out = socket.getOutputStream();
        out.write(("GET " + url + " HTTP/1.1\r\nHost:default\r\nConnection: upgrade\r\nUpgrade: servlet\r\n\r\n").getBytes());
        out.flush();
        Assert.assertTrue((boolean)this.readBytes(in).startsWith("HTTP/1.1 101 Switching Protocols\r\n"));
        out.write("Echo Messages\r\n\r\n".getBytes());
        out.flush();
        Assert.assertEquals((Object)"Echo Messages\r\n\r\n", (Object)this.readBytes(in));
        out.write("Echo Messages2\r\n\r\n".getBytes());
        out.flush();
        Assert.assertEquals((Object)"Echo Messages2\r\n\r\n", (Object)this.readBytes(in));
        out.write("exit\r\n\r\n".getBytes());
        out.flush();
        out.close();
    }

    private String readBytes(InputStream in) throws IOException {
        int read;
        StringBuilder builder = new StringBuilder();
        byte[] buf = new byte[100];
        while (!builder.toString().contains("\r\n\r\n") && (read = in.read(buf)) != -1) {
            builder.append(new String(buf, 0, read));
        }
        return builder.toString();
    }
}

