/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.util.PathTemplate;
import io.undertow.websockets.WebSocketExtension;
import io.undertow.websockets.jsr.FrameHandler;
import jakarta.websocket.Decoder;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Encoder;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="UT")
public interface JsrWebSocketMessages {
    public static final JsrWebSocketMessages MESSAGES = (JsrWebSocketMessages)Messages.getBundle(JsrWebSocketMessages.class);

    @Message(id=3001, value="PongMessage not supported with MessageHandler.Async")
    public IllegalStateException pongMessageNotSupported();

    @Message(id=3002, value="SendStream is closed")
    public IOException sendStreamClosed();

    @Message(id=3003, value="SendWriter is closed")
    public IOException sendWriterClosed();

    @Message(id=3004, value="Client not supported")
    public DeploymentException clientNotSupported();

    @Message(id=3005, value="MessageHandler for type %s already registered")
    public IllegalStateException handlerAlreadyRegistered(FrameHandler.FrameType var1);

    @Message(id=3006, value="Unable to detect FrameType for clazz %s")
    public IllegalStateException unsupportedFrameType(Class<?> var1);

    @Message(id=3007, value="Unable to detect MessageHandler type for %s")
    public IllegalStateException unknownHandlerType(Class<?> var1);

    @Message(id=3008, value="Unable to detect Encoder type for %s")
    public IllegalStateException unknownEncoderType(Class<?> var1);

    @Message(id=3009, value="More than one %s parameter for %s")
    public IllegalArgumentException moreThanOneParameterOfType(Class<?> var1, Method var2);

    @Message(id=3010, value="No parameter of type %s found in method %s")
    public IllegalArgumentException parameterNotFound(Class<?> var1, Method var2);

    @Message(id=3011, value="More than one method is annotated with %s")
    public DeploymentException moreThanOneAnnotation(Class<?> var1);

    @Message(id=3012, value="Method %s has invalid parameters at locations %s")
    public DeploymentException invalidParameters(Method var1, Set<Integer> var2);

    @Message(id=3014, value="Could not determine decoder type for %s")
    public IllegalArgumentException couldNotDetermineDecoderTypeFor(Class<?> var1);

    @Message(id=3015, value="No decoder accepted message %s")
    public String noDecoderAcceptedMessage(List<? extends Decoder> var1);

    @Message(id=3016, value="Cannot send in middle of fragmeneted message")
    public IllegalStateException cannotSendInMiddleOfFragmentedMessage();

    @Message(id=3017, value="Cannot add endpoint after deployment")
    public IllegalStateException cannotAddEndpointAfterDeployment();

    @Message(id=3018, value="Could not determine type of decode method for class %s")
    public DeploymentException couldNotDetermineTypeOfDecodeMethodForClass(Class<? extends Decoder> var1, @Cause Exception var2);

    @Message(id=3019, value="Could not determine type of encode method for class %s")
    public DeploymentException couldNotDetermineTypeOfEncodeMethodForClass(Class<? extends Encoder> var1);

    @Message(id=3020, value="%s did not implement known decoder interface")
    public DeploymentException didNotImplementKnownDecoderSubclass(Class<? extends Decoder> var1);

    @Message(id=3021, value="%s does not have default constructor")
    public DeploymentException classDoesNotHaveDefaultConstructor(Class<?> var1, @Cause NoSuchMethodException var2);

    @Message(id=3023, value="Multiple endpoints with the same logical mapping %s and %s")
    public DeploymentException multipleEndpointsWithOverlappingPaths(PathTemplate var1, PathTemplate var2);

    @Message(id=3024, value="Web socket deployment failed")
    public DeploymentException couldNotDeploy(@Cause Exception var1);

    @Message(id=3025, value="Cannot connect until deployment is complete")
    public IllegalStateException cannotConnectUntilDeploymentComplete();

    @Message(id=3026, value="%s is not a valid client endpoint type")
    public DeploymentException notAValidClientEndpointType(Class<?> var1);

    @Message(id=3027, value="Class %s was not annotated with @ClientEndpoint or @ServerEndpoint")
    public DeploymentException classWasNotAnnotated(Class<?> var1);

    @Message(id=3028, value="Could not find decoder for type %s on method %s")
    public DeploymentException couldNotFindDecoderForType(Class<?> var1, Method var2);

    @Message(id=3029, value="Could not find message parameter on method %s")
    public DeploymentException couldNotFindMessageParameter(Method var1);

    @Message(id=3030, value="Received a text frame however endpoint does not have a method capable of handling it")
    public RuntimeException receivedTextFrameButNoMethod();

    @Message(id=3031, value="Received a binary frame however endpoint does not have a method capable of handling it")
    public RuntimeException receivedBinaryFrameButNoMethod();

    @Message(id=3033, value="Method %s has invalid parameters at locations %s. It looks like you may have accidentally used javax.ws.rs.PathParam instead of javax.websocket.server.PathParam")
    public DeploymentException invalidParametersWithWrongAnnotation(Method var1, Set<Integer> var2);

    @Message(id=3034, value="Server provided extension %s which was not in client supported extensions %s")
    public IOException extensionWasNotPresentInClientHandshake(String var1, List<WebSocketExtension> var2);

    @Message(id=3035, value="Connection timed out")
    public IOException connectionTimedOut();

    @Message(id=3036, value="SendHandler is null")
    public IllegalArgumentException handlerIsNull();

    @Message(id=3037, value="Message is null")
    public IllegalArgumentException messageInNull();

    @Message(id=3038, value="Message of size %s was larger than the maximum of %s")
    public IllegalArgumentException messageTooLarge(int var1, int var2);

    @Message(id=3039, value="The container cannot find a suitable constructor to instantiate endpoint of type %s")
    public InstantiationException cannotInstantiateEndpoint(Class<?> var1);

    @Message(id=3040, value="Annotated endpoint instance %s was not of correct type %s")
    public IllegalArgumentException endpointNotOfCorrectType(Object var1, Class var2);

    @Message(id=3041, value="Annotated endpoint %s does not have a no arg constructor, but is using a custom configurator. The custom configurator must create the instance.")
    public InstantiationException endpointDoesNotHaveAppropriateConstructor(Class<?> var1);

    @Message(id=3042, value="Deployment failed due to invalid programmatically added endpoints")
    public RuntimeException deploymentFailedDueToProgramaticErrors();
}

