/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.api.CloseReason;
import io.undertow.websockets.api.FrameHandler;
import io.undertow.websockets.api.WebSocketSession;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.util.ClassUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import org.xnio.Buffers;

abstract class AbstractFrameHandler<E extends MessageHandler>
implements FrameHandler {
    private final Endpoint endpoint;
    private final UndertowSession session;
    protected static final byte[] EMPTY = new byte[0];
    private final ConcurrentMap<FrameType, HandlerWrapper> handlers = new ConcurrentHashMap<FrameType, HandlerWrapper>();

    protected AbstractFrameHandler(UndertowSession session, Endpoint endpoint) {
        this.session = session;
        this.endpoint = endpoint;
    }

    public final void onPingFrame(WebSocketSession session, ByteBuffer ... payload) {
    }

    public final void onCloseFrame(WebSocketSession s, final CloseReason reason) {
        this.endpoint.onClose((Session)this.session, new javax.websocket.CloseReason(new CloseReason.CloseCode(){

            public int getCode() {
                return reason.getStatusCode();
            }
        }, reason.getReasonText()));
        this.session.close0();
    }

    public void onPongFrame(WebSocketSession session, ByteBuffer ... payload) {
    }

    public final void onError(WebSocketSession s, Throwable cause) {
        this.endpoint.onError((Session)this.session, cause);
    }

    protected static ByteBuffer toBuffer(ByteBuffer ... payload) {
        if (payload.length == 1) {
            return payload[0];
        }
        int size = (int)Buffers.remaining((Buffer[])payload);
        if (size == 0) {
            return Buffers.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (ByteBuffer buf : payload) {
            buffer.put(buf);
        }
        buffer.flip();
        return buffer;
    }

    protected static byte[] toArray(ByteBuffer ... payload) {
        ByteBuffer buf;
        if (payload.length == 1 && (buf = payload[0]).hasArray() && buf.arrayOffset() == 0 && buf.position() == 0) {
            return buf.array();
        }
        int size = (int)Buffers.remaining((Buffer[])payload);
        byte[] data = new byte[size];
        for (ByteBuffer buf2 : payload) {
            buf2.get(data);
        }
        return data;
    }

    private static Class<?> type(MessageHandler handler) {
        Class<?> typeClazz = ClassUtils.getHandlerType(handler.getClass());
        if (typeClazz != String.class && typeClazz != byte[].class && typeClazz != ByteBuffer.class && typeClazz != PongMessage.class) {
            throw JsrWebSocketMessages.MESSAGES.unsupportedFrameType(typeClazz);
        }
        return typeClazz;
    }

    public final void addHandler(E handler) {
        Class<?> type = AbstractFrameHandler.type(handler);
        this.verify(type, handler);
        FrameType frameType = AbstractFrameHandler.getFrameType(type);
        if (this.handlers.containsKey((Object)frameType)) {
            throw JsrWebSocketMessages.MESSAGES.handlerAlreadyRegistered(frameType);
        }
        HandlerWrapper wrapper = new HandlerWrapper((MessageHandler)handler);
        if (this.handlers.putIfAbsent(frameType, wrapper) != null) {
            throw JsrWebSocketMessages.MESSAGES.handlerAlreadyRegistered(frameType);
        }
    }

    protected static FrameType getFrameType(Class<?> type) {
        if (type == byte[].class || type == ByteBuffer.class) {
            return FrameType.BYTE;
        }
        if (type == String.class) {
            return FrameType.TEXT;
        }
        if (type == PongMessage.class) {
            return FrameType.PONG;
        }
        throw JsrWebSocketMessages.MESSAGES.unsupportedFrameType(type);
    }

    protected void verify(Class<?> type, E handler) {
    }

    public final void removeHandler(E handler) {
        Class<?> type = AbstractFrameHandler.type(handler);
        FrameType frameType = AbstractFrameHandler.getFrameType(type);
        HandlerWrapper wrapper = (HandlerWrapper)this.handlers.get((Object)frameType);
        if (wrapper != null && wrapper.getMessageType() == type) {
            this.handlers.remove((Object)frameType, wrapper);
        }
    }

    public final Set<MessageHandler> getHandlers() {
        HashSet<MessageHandler> msgHandlers = new HashSet<MessageHandler>();
        for (HandlerWrapper handler : this.handlers.values()) {
            msgHandlers.add(handler.getHandler());
        }
        return msgHandlers;
    }

    protected final HandlerWrapper getHandler(FrameType type) {
        return (HandlerWrapper)this.handlers.get((Object)type);
    }

    static final class HandlerWrapper {
        private final MessageHandler handler;
        private final Class<?> msgType;

        private HandlerWrapper(MessageHandler handler) {
            this.msgType = AbstractFrameHandler.type(handler);
            this.handler = handler;
        }

        public MessageHandler getHandler() {
            return this.handler;
        }

        public Class<?> getMessageType() {
            return this.msgType;
        }
    }

    static enum FrameType {
        PONG,
        BYTE,
        TEXT;

    }
}

