/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.client.HttpClient;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import io.undertow.websockets.api.WebSocketSessionIdGenerator;
import io.undertow.websockets.client.WebSocketClient;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.impl.UuidWebSocketSessionIdGenerator;
import io.undertow.websockets.impl.WebSocketChannelSession;
import io.undertow.websockets.impl.WebSocketRecieveListeners;
import io.undertow.websockets.jsr.ConfiguredClientEndpoint;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.EncodingFactory;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.PathTemplate;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.annotated.AnnotatedEndpointFactory;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Pool;

public class ServerWebSocketContainer
implements ServerContainer {
    private final ClassIntrospecter classIntrospecter;
    private final WebSocketSessionIdGenerator sessionIdGenerator = new UuidWebSocketSessionIdGenerator();
    private final Map<Class<?>, ConfiguredClientEndpoint> clientEndpoints = new HashMap();
    private final List<ConfiguredServerEndpoint> configuredServerEndpoints = new ArrayList<ConfiguredServerEndpoint>();
    private final TreeSet<PathTemplate> seenPaths = new TreeSet();
    private HttpClient httpClient;
    private Pool<ByteBuffer> bufferPool;
    private volatile long defaultAsyncSendTimeout;
    private volatile long maxSessionIdleTimeout;
    private volatile int defaultMaxBinaryMessageBufferSize;
    private volatile int defaultMaxTextMessageBufferSize;
    private volatile boolean deploymentComplete = false;

    public ServerWebSocketContainer(ClassIntrospecter classIntrospecter) {
        this.classIntrospecter = classIntrospecter;
    }

    public void start(HttpClient httpClient, Pool<ByteBuffer> bufferPool) {
        this.httpClient = httpClient;
        this.bufferPool = bufferPool;
    }

    public void stop() {
        this.httpClient = null;
        this.bufferPool = null;
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout;
    }

    public void setAsyncSendTimeout(long defaultAsyncSendTimeout) {
        this.defaultAsyncSendTimeout = defaultAsyncSendTimeout;
    }

    public Session connectToServer(Object annotatedEndpointInstance, URI path) throws DeploymentException, IOException {
        ConfiguredClientEndpoint config = this.getClientEndpoint(annotatedEndpointInstance.getClass());
        if (config == null) {
            throw JsrWebSocketMessages.MESSAGES.notAValidClientEndpointType(annotatedEndpointInstance.getClass());
        }
        Endpoint instance = config.getFactory().createInstanceForExisting(annotatedEndpointInstance);
        return this.connectToServerInternal(instance, config, path);
    }

    public Session connectToServer(Class<?> aClass, URI uri) throws DeploymentException, IOException {
        ConfiguredClientEndpoint config = this.getClientEndpoint(aClass);
        if (config == null) {
            throw JsrWebSocketMessages.MESSAGES.notAValidClientEndpointType(aClass);
        }
        try {
            InstanceHandle<Endpoint> instance = config.getFactory().createInstance();
            return this.connectToServerInternal((Endpoint)instance.getInstance(), config, uri);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public Session connectToServer(Endpoint endpointInstance, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        IoFuture session = WebSocketClient.connect((HttpClient)this.httpClient, this.bufferPool, (OptionMap)OptionMap.EMPTY, (URI)path, (WebSocketVersion)WebSocketVersion.V13);
        WebSocketChannel channel = (WebSocketChannel)session.get();
        EndpointSessionHandler sessionHandler = new EndpointSessionHandler(this);
        WebSocketChannelSession wss = new WebSocketChannelSession(channel, this.sessionIdGenerator.nextId(), false);
        WebSocketRecieveListeners.startRecieving((WebSocketChannelSession)wss, (WebSocketChannel)channel, (boolean)false);
        EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, cec.getDecoders(), cec.getEncoders());
        UndertowSession undertowSession = new UndertowSession(wss, path, Collections.emptyMap(), Collections.emptyMap(), sessionHandler, null, (InstanceHandle<Endpoint>)new ImmediateInstanceHandle((Object)endpointInstance), (EndpointConfig)cec, encodingFactory.createEncoding((EndpointConfig)cec));
        endpointInstance.onOpen((Session)undertowSession, (EndpointConfig)cec);
        return undertowSession;
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        try {
            Endpoint endpoint = endpointClass.newInstance();
            return this.connectToServer(endpoint, cec, path);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public Session connectToServerInternal(Endpoint endpointInstance, ConfiguredClientEndpoint cec, URI path) throws DeploymentException, IOException {
        IoFuture session = WebSocketClient.connect((HttpClient)this.httpClient, this.bufferPool, (OptionMap)OptionMap.EMPTY, (URI)path, (WebSocketVersion)WebSocketVersion.V13);
        WebSocketChannel channel = (WebSocketChannel)session.get();
        EndpointSessionHandler sessionHandler = new EndpointSessionHandler(this);
        WebSocketChannelSession wss = new WebSocketChannelSession(channel, this.sessionIdGenerator.nextId(), false);
        WebSocketRecieveListeners.startRecieving((WebSocketChannelSession)wss, (WebSocketChannel)channel, (boolean)false);
        UndertowSession undertowSession = new UndertowSession(wss, path, Collections.emptyMap(), Collections.emptyMap(), sessionHandler, null, (InstanceHandle<Endpoint>)new ImmediateInstanceHandle((Object)endpointInstance), (EndpointConfig)cec.getConfig(), cec.getEncodingFactory().createEncoding((EndpointConfig)cec.getConfig()));
        endpointInstance.onOpen((Session)undertowSession, (EndpointConfig)cec.getConfig());
        return undertowSession;
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.maxSessionIdleTimeout;
    }

    public void setDefaultMaxSessionIdleTimeout(long timeout) {
        this.maxSessionIdleTimeout = timeout;
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.defaultMaxBinaryMessageBufferSize;
    }

    public void setDefaultMaxBinaryMessageBufferSize(int defaultMaxBinaryMessageBufferSize) {
        this.defaultMaxBinaryMessageBufferSize = defaultMaxBinaryMessageBufferSize;
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.defaultMaxTextMessageBufferSize;
    }

    public void setDefaultMaxTextMessageBufferSize(int defaultMaxTextMessageBufferSize) {
        this.defaultMaxTextMessageBufferSize = defaultMaxTextMessageBufferSize;
    }

    public Set<Extension> getInstalledExtensions() {
        return Collections.emptySet();
    }

    public void addEndpoint(Class<?> endpoint) throws DeploymentException {
        block7: {
            if (this.deploymentComplete) {
                throw JsrWebSocketMessages.MESSAGES.cannotAddEndpointAfterDeployment();
            }
            try {
                ServerEndpoint serverEndpoint = endpoint.getAnnotation(ServerEndpoint.class);
                ClientEndpoint clientEndpoint = endpoint.getAnnotation(ClientEndpoint.class);
                if (serverEndpoint != null) {
                    PathTemplate template = PathTemplate.create(serverEndpoint.value());
                    if (this.seenPaths.contains(template)) {
                        PathTemplate existing = null;
                        for (PathTemplate p : this.seenPaths) {
                            if (p.compareTo(template) != 0) continue;
                            existing = p;
                            break;
                        }
                        throw JsrWebSocketMessages.MESSAGES.multipleEndpointsWithOverlappingPaths(template, existing);
                    }
                    this.seenPaths.add(template);
                    EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, serverEndpoint.decoders(), serverEndpoint.encoders());
                    AnnotatedEndpointFactory factory = AnnotatedEndpointFactory.create(endpoint, this.classIntrospecter.createInstanceFactory(endpoint), encodingFactory);
                    ServerEndpointConfig config = ServerEndpointConfig.Builder.create(endpoint, (String)serverEndpoint.value()).decoders(Arrays.asList(serverEndpoint.decoders())).encoders(Arrays.asList(serverEndpoint.encoders())).subprotocols(Arrays.asList(serverEndpoint.subprotocols())).configurator((ServerEndpointConfig.Configurator)new ServerInstanceFactoryConfigurator(factory)).build();
                    ConfiguredServerEndpoint confguredServerEndpoint = new ConfiguredServerEndpoint(config, factory, template, encodingFactory);
                    this.configuredServerEndpoints.add(confguredServerEndpoint);
                    break block7;
                }
                if (clientEndpoint != null) {
                    EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, clientEndpoint.decoders(), clientEndpoint.encoders());
                    AnnotatedEndpointFactory factory = AnnotatedEndpointFactory.create(endpoint, this.classIntrospecter.createInstanceFactory(endpoint), encodingFactory);
                    ClientEndpointConfig config = ClientEndpointConfig.Builder.create().decoders(Arrays.asList(clientEndpoint.decoders())).encoders(Arrays.asList(clientEndpoint.encoders())).preferredSubprotocols(Arrays.asList(clientEndpoint.subprotocols())).configurator((ClientEndpointConfig.Configurator)clientEndpoint.configurator().newInstance()).build();
                    ConfiguredClientEndpoint configuredClientEndpoint = new ConfiguredClientEndpoint(config, factory, encodingFactory);
                    this.clientEndpoints.put(endpoint, configuredClientEndpoint);
                    break block7;
                }
                throw JsrWebSocketMessages.MESSAGES.classWasNotAnnotated(endpoint);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
            }
        }
    }

    public void addEndpoint(ServerEndpointConfig endpoint) throws DeploymentException {
        if (this.deploymentComplete) {
            throw JsrWebSocketMessages.MESSAGES.cannotAddEndpointAfterDeployment();
        }
        PathTemplate template = PathTemplate.create(endpoint.getPath());
        if (this.seenPaths.contains(template)) {
            PathTemplate existing = null;
            for (PathTemplate p : this.seenPaths) {
                if (p.compareTo(template) != 0) continue;
                existing = p;
                break;
            }
            throw JsrWebSocketMessages.MESSAGES.multipleEndpointsWithOverlappingPaths(template, existing);
        }
        this.seenPaths.add(template);
        EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, endpoint.getDecoders(), endpoint.getEncoders());
        ConfiguredServerEndpoint confguredServerEndpoint = new ConfiguredServerEndpoint(endpoint, null, template, encodingFactory);
        this.configuredServerEndpoints.add(confguredServerEndpoint);
    }

    public ConfiguredClientEndpoint getClientEndpoint(Class<?> type) {
        return this.clientEndpoints.get(type);
    }

    public void deploymentComplete() {
        this.deploymentComplete = true;
    }

    public List<ConfiguredServerEndpoint> getConfiguredServerEndpoints() {
        return this.configuredServerEndpoints;
    }

    private static final class ServerInstanceFactoryConfigurator
    extends ServerEndpointConfig.Configurator {
        private final InstanceFactory<?> factory;

        private ServerInstanceFactoryConfigurator(InstanceFactory<?> factory) {
            this.factory = factory;
        }

        public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
            return (T)this.factory.createInstance().getInstance();
        }
    }
}

