/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.api.InstanceHandle;
import io.undertow.websockets.api.WebSocketSession;
import io.undertow.websockets.api.WebSocketSessionHandler;
import io.undertow.websockets.impl.WebSocketChannelSession;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.JsrWebSocketLogger;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.Closeable;
import java.net.URI;
import java.util.Collections;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfiguration;
import javax.websocket.Session;
import org.xnio.IoUtils;

final class EndpointSessionHandler
implements WebSocketSessionHandler {
    private final ServerWebSocketContainer container;

    EndpointSessionHandler(ServerWebSocketContainer container) {
        this.container = container;
    }

    ServerWebSocketContainer getContainer() {
        return this.container;
    }

    public void onSession(WebSocketSession s, WebSocketHttpExchange exchange) {
        WebSocketChannelSession channelSession = (WebSocketChannelSession)s;
        ConfiguredServerEndpoint config = HandshakeUtil.getConfig(channelSession.getChannel());
        try {
            InstanceHandle instance = config.getEndpointFactory().createInstance();
            UndertowSession session = new UndertowSession(channelSession, URI.create(exchange.getRequestURI()), Collections.emptyMap(), Collections.emptyMap(), this, null, (InstanceHandle<Endpoint>)instance, (EndpointConfiguration)config.getEndpointConfiguration());
            session.setMaxBinaryMessageBufferSize(this.getContainer().getDefaultMaxBinaryMessageBufferSize());
            session.setMaxTextMessageBufferSize(this.getContainer().getDefaultMaxTextMessageBufferSize());
            session.getAsyncRemote().setSendTimeout(this.getContainer().getDefaultAsyncSendTimeout());
            ((Endpoint)instance.getInstance()).onOpen((Session)session, (EndpointConfiguration)config.getEndpointConfiguration());
        }
        catch (InstantiationException e) {
            JsrWebSocketLogger.REQUEST_LOGGER.endpointCreationFailed(e);
            IoUtils.safeClose((Closeable)channelSession.getChannel());
        }
    }
}

