/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.jsr.Encoding;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.FrameHandler;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.WebSocketSessionRemoteEndpoint;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;

public final class UndertowSession
implements Session {
    private final String sessionId;
    private final WebSocketChannel webSocketChannel;
    private final FrameHandler frameHandler;
    private final ServerWebSocketContainer container;
    private final Principal user;
    private final WebSocketSessionRemoteEndpoint remote;
    private final Map<String, Object> attrs = new ConcurrentHashMap<String, Object>();
    private final Map<String, List<String>> requestParameterMap;
    private final URI requestUri;
    private final String queryString;
    private final Map<String, String> pathParameters;
    private final InstanceHandle<Endpoint> endpoint;
    private final Encoding encoding;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Set<Session> openSessions;

    public UndertowSession(WebSocketChannel webSocketChannel, URI requestUri, Map<String, String> pathParameters, Map<String, List<String>> requestParameterMap, EndpointSessionHandler handler, Principal user, InstanceHandle<Endpoint> endpoint, EndpointConfig config, String queryString, Encoding encoding, Set<Session> openSessions) {
        this.webSocketChannel = webSocketChannel;
        this.queryString = queryString;
        this.encoding = encoding;
        this.openSessions = openSessions;
        this.container = handler.getContainer();
        this.user = user;
        this.requestUri = requestUri;
        this.requestParameterMap = Collections.unmodifiableMap(requestParameterMap);
        this.pathParameters = Collections.unmodifiableMap(pathParameters);
        this.remote = new WebSocketSessionRemoteEndpoint(webSocketChannel, config, encoding);
        this.endpoint = endpoint;
        webSocketChannel.getCloseSetter().set((ChannelListener)new ChannelListener<Channel>(){

            public void handleEvent(Channel channel) {
                UndertowSession.this.close0();
            }
        });
        this.frameHandler = new FrameHandler(this, (Endpoint)this.endpoint.getInstance());
        webSocketChannel.getReceiveSetter().set((ChannelListener)this.frameHandler);
        this.sessionId = new SecureRandomSessionIdGenerator().createSessionId();
    }

    public ServerWebSocketContainer getContainer() {
        return this.container;
    }

    public synchronized void addMessageHandler(MessageHandler messageHandler) throws IllegalStateException {
        this.frameHandler.addHandler(messageHandler);
    }

    public synchronized Set<MessageHandler> getMessageHandlers() {
        return this.frameHandler.getHandlers();
    }

    public synchronized void removeMessageHandler(MessageHandler messageHandler) {
        this.frameHandler.removeHandler(messageHandler);
    }

    public void setReceiveListener(ChannelListener<WebSocketChannel> handler) {
        this.webSocketChannel.getReceiveSetter().set(handler);
    }

    public String getProtocolVersion() {
        return this.webSocketChannel.getVersion().toHttpHeaderValue();
    }

    public String getNegotiatedSubprotocol() {
        return "";
    }

    public boolean isSecure() {
        return this.webSocketChannel.isSecure();
    }

    public boolean isOpen() {
        return this.webSocketChannel.isOpen();
    }

    public long getMaxIdleTimeout() {
        return this.webSocketChannel.getIdleTimeout();
    }

    public void setMaxIdleTimeout(long milliseconds) {
        this.webSocketChannel.setIdleTimeout(milliseconds);
    }

    public String getId() {
        return this.sessionId;
    }

    public void close() throws IOException {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(CloseReason closeReason) throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                if (closeReason == null) {
                    ((Endpoint)this.endpoint.getInstance()).onClose((Session)this, new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NO_STATUS_CODE, null));
                } else {
                    ((Endpoint)this.endpoint.getInstance()).onClose((Session)this, closeReason);
                }
                if (!this.webSocketChannel.isCloseFrameReceived()) {
                    if (closeReason == null) {
                        this.webSocketChannel.sendClose();
                    } else {
                        WebSockets.sendClose((ByteBuffer)new CloseMessage(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase()).toByteBuffer(), (WebSocketChannel)this.webSocketChannel, null);
                    }
                }
            }
            finally {
                this.close0();
            }
        }
    }

    public void forceClose() {
        IoUtils.safeClose((Closeable)this.webSocketChannel);
    }

    public URI getRequestURI() {
        return this.requestUri;
    }

    public Map<String, List<String>> getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public Map<String, Object> getUserProperties() {
        return this.attrs;
    }

    public Principal getUserPrincipal() {
        return this.user;
    }

    public void setMaxBinaryMessageBufferSize(int i) {
    }

    public int getMaxBinaryMessageBufferSize() {
        return 0;
    }

    public void setMaxTextMessageBufferSize(int i) {
    }

    public int getMaxTextMessageBufferSize() {
        return 0;
    }

    public RemoteEndpoint.Async getAsyncRemote() {
        return this.remote.getAsync();
    }

    public RemoteEndpoint.Basic getBasicRemote() {
        return this.remote.getBasic();
    }

    public Set<Session> getOpenSessions() {
        return new HashSet<Session>(this.openSessions);
    }

    public List<Extension> getNegotiatedExtensions() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close0() {
        this.openSessions.remove(this);
        try {
            this.endpoint.release();
        }
        finally {
            this.encoding.close();
        }
    }

    public Encoding getEncoding() {
        return this.encoding;
    }
}

