/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.websockets.ServletWebSocketHttpExchange;
import io.undertow.util.PathTemplateMatcher;
import io.undertow.websockets.core.handler.WebSocketConnectionCallback;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.jsr.handshake.JsrHybi07Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi08Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi13Handshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.server.ServerContainer;

public class JsrWebSocketFilter
implements Filter {
    private WebSocketConnectionCallback callback;
    private PathTemplateMatcher<WebSocketHandshakeHolder> pathTemplateMatcher;

    protected WebSocketHandshakeHolder handshakes(ConfiguredServerEndpoint config) {
        ArrayList<Object> handshakes = new ArrayList<Object>();
        handshakes.add((Object)new JsrHybi13Handshake(config));
        handshakes.add((Object)new JsrHybi08Handshake(config));
        handshakes.add((Object)new JsrHybi07Handshake(config));
        return new WebSocketHandshakeHolder(handshakes, config);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServerWebSocketContainer container = (ServerWebSocketContainer)filterConfig.getServletContext().getAttribute(ServerContainer.class.getName());
        container.deploymentComplete();
        this.pathTemplateMatcher = new PathTemplateMatcher();
        for (ConfiguredServerEndpoint endpoint : container.getConfiguredServerEndpoints()) {
            this.pathTemplateMatcher.add(endpoint.getPathTemplate(), (Object)this.handshakes(endpoint));
        }
        this.callback = new EndpointSessionHandler(container);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (req.getHeader("Upgrade") != null) {
            PathTemplateMatcher.PathMatchResult matchResult;
            ServletWebSocketHttpExchange facade = new ServletWebSocketHttpExchange(req, resp);
            String path = req.getPathInfo() == null ? req.getServletPath() : req.getServletPath() + req.getPathInfo();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if ((matchResult = this.pathTemplateMatcher.match(path)) != null) {
                Handshake handshaker = null;
                for (Handshake method : ((WebSocketHandshakeHolder)matchResult.getValue()).handshakes) {
                    if (!method.matches((WebSocketHttpExchange)facade)) continue;
                    handshaker = method;
                    break;
                }
                if (handshaker == null) {
                    chain.doFilter(request, response);
                } else {
                    facade.putAttachment(HandshakeUtil.PATH_PARAMS, (Object)matchResult.getParameters());
                    handshaker.handshake((WebSocketHttpExchange)facade, this.callback);
                    return;
                }
            }
            chain.doFilter(request, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private static final class WebSocketHandshakeHolder {
        final List<Handshake> handshakes;
        final ConfiguredServerEndpoint endpoint;

        private WebSocketHandshakeHolder(List<Handshake> handshakes, ConfiguredServerEndpoint endpoint) {
            this.handshakes = handshakes;
            this.endpoint = endpoint;
        }
    }
}

