/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.annotated;

import io.undertow.websockets.jsr.JsrWebSocketMessages;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;

public abstract class CombinedDecoder<T extends Decoder> {
    protected final List<T> decoders;

    public CombinedDecoder(List<T> decoders) {
        this.decoders = decoders;
    }

    static class Binary<T>
    extends CombinedDecoder<Decoder.Binary<T>> {
        public Binary(List<Decoder.Binary<T>> decoders) {
            super(decoders);
        }

        public T decode(ByteBuffer value) throws IOException, DecodeException {
            for (Decoder.Binary decoder : this.decoders) {
                if (!decoder.willDecode(value)) continue;
                return (T)decoder.decode(value);
            }
            throw new DecodeException(value, JsrWebSocketMessages.MESSAGES.noDecoderAcceptedMessage(this.decoders));
        }
    }

    static class Text<T>
    extends CombinedDecoder<Decoder.Text<T>> {
        public Text(List<Decoder.Text<T>> decoders) {
            super(decoders);
        }

        public T decode(String value) throws IOException, DecodeException {
            for (Decoder.Text decoder : this.decoders) {
                if (!decoder.willDecode(value)) continue;
                return (T)decoder.decode(value);
            }
            throw new DecodeException(value, JsrWebSocketMessages.MESSAGES.noDecoderAcceptedMessage(this.decoders));
        }
    }
}

