/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.DefaultContainerConfigurator;
import io.undertow.websockets.jsr.JsrWebSocketLogger;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.annotated.AnnotatedEndpoint;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.Closeable;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpointConfig;
import org.xnio.IoUtils;

public final class EndpointSessionHandler
implements WebSocketConnectionCallback {
    private final ServerWebSocketContainer container;

    public EndpointSessionHandler(ServerWebSocketContainer container) {
        this.container = container;
    }

    ServerWebSocketContainer getContainer() {
        return this.container;
    }

    public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
        ConfiguredServerEndpoint config = HandshakeUtil.getConfig(channel);
        try {
            Object endpointInstance;
            if (this.container.isClosed()) {
                channel.sendClose();
                channel.resumeReceives();
                return;
            }
            InstanceFactory<?> endpointFactory = config.getEndpointFactory();
            ServerEndpointConfig.Configurator configurator = config.getEndpointConfiguration().getConfigurator();
            DefaultContainerConfigurator.setCurrentInstanceFactory(endpointFactory);
            final Object instanceFromConfigurator = configurator.getEndpointInstance(config.getEndpointConfiguration().getEndpointClass());
            final InstanceHandle<Object> factoryInstance = DefaultContainerConfigurator.clearCurrentInstanceFactory();
            InstanceHandle<Object> instance = factoryInstance == null ? new ImmediateInstanceHandle(instanceFromConfigurator) : (factoryInstance.getInstance() == instanceFromConfigurator ? factoryInstance : new InstanceHandle<Object>(){

                public Object getInstance() {
                    return instanceFromConfigurator;
                }

                public void release() {
                    factoryInstance.release();
                }
            });
            ServletRequestContext src = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            Principal principal = src.getServletRequest() instanceof HttpServletRequest ? ((HttpServletRequest)src.getServletRequest()).getUserPrincipal() : src.getOriginalRequest().getUserPrincipal();
            if (config.getAnnotatedEndpointFactory() != null) {
                final AnnotatedEndpoint annotated = config.getAnnotatedEndpointFactory().createInstance(instance);
                endpointInstance = new InstanceHandle<Endpoint>((InstanceHandle)instance){
                    final /* synthetic */ InstanceHandle val$instance;
                    {
                        this.val$instance = instanceHandle;
                    }

                    public Endpoint getInstance() {
                        return annotated;
                    }

                    public void release() {
                        this.val$instance.release();
                    }
                };
            } else {
                endpointInstance = instance;
            }
            UndertowSession session = new UndertowSession(channel, URI.create(exchange.getRequestURI()), (Map)exchange.getAttachment(HandshakeUtil.PATH_PARAMS), exchange.getRequestParameters(), this, principal, (InstanceHandle<Endpoint>)endpointInstance, (EndpointConfig)config.getEndpointConfiguration(), exchange.getQueryString(), config.getEncodingFactory().createEncoding((EndpointConfig)config.getEndpointConfiguration()), config, channel.getSubProtocol(), Collections.emptyList(), null);
            config.addOpenSession(session);
            session.setMaxBinaryMessageBufferSize(this.getContainer().getDefaultMaxBinaryMessageBufferSize());
            session.setMaxTextMessageBufferSize(this.getContainer().getDefaultMaxTextMessageBufferSize());
            session.setMaxIdleTimeout(this.getContainer().getDefaultMaxSessionIdleTimeout());
            session.getAsyncRemote().setSendTimeout(this.getContainer().getDefaultAsyncSendTimeout());
            try {
                ((Endpoint)endpointInstance.getInstance()).onOpen((Session)session, (EndpointConfig)config.getEndpointConfiguration());
            }
            catch (Exception e) {
                ((Endpoint)endpointInstance.getInstance()).onError((Session)session, (Throwable)e);
                IoUtils.safeClose((Closeable)((Object)session));
            }
            channel.resumeReceives();
        }
        catch (Exception e) {
            JsrWebSocketLogger.REQUEST_LOGGER.endpointCreationFailed(e);
            IoUtils.safeClose((Closeable)channel);
        }
    }
}

