/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.util.DefaultClassIntrospector;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.ContainerProvider;
import javax.websocket.WebSocketContainer;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class UndertowContainerProvider
extends ContainerProvider {
    private static final boolean directBuffers = Boolean.getBoolean("io.undertow.websockets.direct-buffers");
    private static final boolean invokeInIoThread = Boolean.getBoolean("io.undertow.websockets.invoke-in-io-thread");
    private static final RuntimePermission PERMISSION = new RuntimePermission("io.undertow.websockets.jsr.MODIFY_WEBSOCKET_CONTAINER");
    private static final Map<ClassLoader, WebSocketContainer> webSocketContainers = new ConcurrentHashMap<ClassLoader, WebSocketContainer>();
    private static volatile WebSocketContainer defaultContainer;
    private static volatile boolean defaultContainerDisabled;
    private static final SwitchableClassIntrospector defaultIntrospector;

    protected WebSocketContainer getContainer() {
        ClassLoader tccl = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        WebSocketContainer webSocketContainer = webSocketContainers.get(tccl);
        if (webSocketContainer == null) {
            return this.getDefaultContainer();
        }
        return webSocketContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebSocketContainer getDefaultContainer() {
        if (defaultContainerDisabled) {
            return null;
        }
        if (defaultContainer != null) {
            return defaultContainer;
        }
        Class<UndertowContainerProvider> clazz = UndertowContainerProvider.class;
        synchronized (UndertowContainerProvider.class) {
            if (defaultContainer == null) {
                try {
                    XnioWorker worker = Xnio.getInstance().createWorker(OptionMap.create((Option)Options.THREAD_DAEMON, (Object)true));
                    DefaultByteBufferPool buffers = new DefaultByteBufferPool(directBuffers, 1024, 100, 12);
                    defaultContainer = new ServerWebSocketContainer((ClassIntrospecter)defaultIntrospector, UndertowContainerProvider.class.getClassLoader(), worker, (ByteBufferPool)buffers, (ThreadSetupAction)new CompositeThreadSetupAction(Collections.emptyList()), !invokeInIoThread);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultContainer;
        }
    }

    public static void addContainer(ClassLoader classLoader, WebSocketContainer webSocketContainer) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PERMISSION);
        }
        webSocketContainers.put(classLoader, webSocketContainer);
    }

    public static void removeContainer(ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PERMISSION);
        }
        webSocketContainers.remove(classLoader);
    }

    public void setDefaultClassIntrospector(ClassIntrospecter classIntrospector) {
        if (classIntrospector == null) {
            throw new IllegalArgumentException();
        }
        defaultIntrospector.setIntrospecter(classIntrospector);
    }

    public static void disableDefaultContainer() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PERMISSION);
        }
        defaultContainerDisabled = true;
    }

    static {
        defaultContainerDisabled = false;
        defaultIntrospector = new SwitchableClassIntrospector();
    }

    private static class SwitchableClassIntrospector
    implements ClassIntrospecter {
        private volatile ClassIntrospecter introspecter = DefaultClassIntrospector.INSTANCE;

        private SwitchableClassIntrospector() {
        }

        public <T> InstanceFactory<T> createInstanceFactory(Class<T> clazz) throws NoSuchMethodException {
            return this.introspecter.createInstanceFactory(clazz);
        }

        public void setIntrospecter(ClassIntrospecter introspecter) {
            this.introspecter = introspecter;
        }
    }
}

