package io.undertow.websockets.jsr;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.String;
import io.undertow.util.PathTemplate;
import java.lang.Exception;
import java.lang.NoSuchMethodException;
import java.lang.RuntimeException;
import io.undertow.websockets.jsr.FrameHandler.FrameType;
import javax.websocket.DeploymentException;
import java.lang.Object;
import java.lang.Class;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.InstantiationException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2019-02-20T10:48:26-0300")
public class JsrWebSocketMessages_$bundle implements JsrWebSocketMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected JsrWebSocketMessages_$bundle() {}
    public static final JsrWebSocketMessages_$bundle INSTANCE = new JsrWebSocketMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String pongMessageNotSupported = "UT003001: PongMessage not supported with MessageHandler.Async";
    protected String pongMessageNotSupported$str() {
        return pongMessageNotSupported;
    }
    @Override
    public final IllegalStateException pongMessageNotSupported() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), pongMessageNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sendStreamClosed = "UT003002: SendStream is closed";
    protected String sendStreamClosed$str() {
        return sendStreamClosed;
    }
    @Override
    public final IOException sendStreamClosed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), sendStreamClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sendWriterClosed = "UT003003: SendWriter is closed";
    protected String sendWriterClosed$str() {
        return sendWriterClosed;
    }
    @Override
    public final IOException sendWriterClosed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), sendWriterClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String clientNotSupported = "UT003004: Client not supported";
    protected String clientNotSupported$str() {
        return clientNotSupported;
    }
    @Override
    public final DeploymentException clientNotSupported() {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), clientNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String handlerAlreadyRegistered = "UT003005: MessageHandler for type %s already registered";
    protected String handlerAlreadyRegistered$str() {
        return handlerAlreadyRegistered;
    }
    @Override
    public final IllegalStateException handlerAlreadyRegistered(final FrameType frameType) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), handlerAlreadyRegistered$str(), frameType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedFrameType = "UT003006: Unable to detect FrameType for clazz %s";
    protected String unsupportedFrameType$str() {
        return unsupportedFrameType;
    }
    @Override
    public final IllegalStateException unsupportedFrameType(final Class<?> clazz) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unsupportedFrameType$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownHandlerType = "UT003007: Unable to detect MessageHandler type for %s";
    protected String unknownHandlerType$str() {
        return unknownHandlerType;
    }
    @Override
    public final IllegalStateException unknownHandlerType(final Class<?> clazz) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownHandlerType$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownEncoderType = "UT003008: Unable to detect Encoder type for %s";
    protected String unknownEncoderType$str() {
        return unknownEncoderType;
    }
    @Override
    public final IllegalStateException unknownEncoderType(final Class<?> clazz) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownEncoderType$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String moreThanOneParameterOfType = "UT003009: More than one %s parameter for %s";
    protected String moreThanOneParameterOfType$str() {
        return moreThanOneParameterOfType;
    }
    @Override
    public final IllegalArgumentException moreThanOneParameterOfType(final Class<?> type, final Method method) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), moreThanOneParameterOfType$str(), type, method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parameterNotFound = "UT003010: No parameter of type %s found in method %s";
    protected String parameterNotFound$str() {
        return parameterNotFound;
    }
    @Override
    public final IllegalArgumentException parameterNotFound(final Class<?> type, final Method method) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), parameterNotFound$str(), type, method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String moreThanOneAnnotation = "UT003011: More than one method is annotated with %s";
    protected String moreThanOneAnnotation$str() {
        return moreThanOneAnnotation;
    }
    @Override
    public final DeploymentException moreThanOneAnnotation(final Class<?> clazz) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), moreThanOneAnnotation$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParameters = "UT003012: Method %s has invalid parameters at locations %s";
    protected String invalidParameters$str() {
        return invalidParameters;
    }
    @Override
    public final DeploymentException invalidParameters(final Method method, final java.util.Set<Integer> allParams) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), invalidParameters$str(), method, allParams));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotDetermineDecoderTypeFor = "UT003014: Could not determine decoder type for %s";
    protected String couldNotDetermineDecoderTypeFor$str() {
        return couldNotDetermineDecoderTypeFor;
    }
    @Override
    public final IllegalArgumentException couldNotDetermineDecoderTypeFor(final Class<?> decoderClass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), couldNotDetermineDecoderTypeFor$str(), decoderClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDecoderAcceptedMessage = "UT003015: No decoder accepted message %s";
    protected String noDecoderAcceptedMessage$str() {
        return noDecoderAcceptedMessage;
    }
    @Override
    public final String noDecoderAcceptedMessage(final java.util.List<? extends javax.websocket.Decoder> decoders) {
        return String.format(getLoggingLocale(), noDecoderAcceptedMessage$str(), decoders);
    }
    private static final String cannotSendInMiddleOfFragmentedMessage = "UT003016: Cannot send in middle of fragmeneted message";
    protected String cannotSendInMiddleOfFragmentedMessage$str() {
        return cannotSendInMiddleOfFragmentedMessage;
    }
    @Override
    public final IllegalStateException cannotSendInMiddleOfFragmentedMessage() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotSendInMiddleOfFragmentedMessage$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddEndpointAfterDeployment = "UT003017: Cannot add endpoint after deployment";
    protected String cannotAddEndpointAfterDeployment$str() {
        return cannotAddEndpointAfterDeployment;
    }
    @Override
    public final IllegalStateException cannotAddEndpointAfterDeployment() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotAddEndpointAfterDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotDetermineTypeOfDecodeMethodForClass = "UT003018: Could not determine type of decode method for class %s";
    protected String couldNotDetermineTypeOfDecodeMethodForClass$str() {
        return couldNotDetermineTypeOfDecodeMethodForClass;
    }
    @Override
    public final DeploymentException couldNotDetermineTypeOfDecodeMethodForClass(final Class<? extends javax.websocket.Decoder> decoder, final Exception e) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), couldNotDetermineTypeOfDecodeMethodForClass$str(), decoder), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotDetermineTypeOfEncodeMethodForClass = "UT003019: Could not determine type of encode method for class %s";
    protected String couldNotDetermineTypeOfEncodeMethodForClass$str() {
        return couldNotDetermineTypeOfEncodeMethodForClass;
    }
    @Override
    public final DeploymentException couldNotDetermineTypeOfEncodeMethodForClass(final Class<? extends javax.websocket.Encoder> encoder) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), couldNotDetermineTypeOfEncodeMethodForClass$str(), encoder));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String didNotImplementKnownDecoderSubclass = "UT003020: %s did not implement known decoder interface";
    protected String didNotImplementKnownDecoderSubclass$str() {
        return didNotImplementKnownDecoderSubclass;
    }
    @Override
    public final DeploymentException didNotImplementKnownDecoderSubclass(final Class<? extends javax.websocket.Decoder> decoder) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), didNotImplementKnownDecoderSubclass$str(), decoder));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String classDoesNotHaveDefaultConstructor = "UT003021: %s does not have default constructor";
    protected String classDoesNotHaveDefaultConstructor$str() {
        return classDoesNotHaveDefaultConstructor;
    }
    @Override
    public final DeploymentException classDoesNotHaveDefaultConstructor(final Class<?> c, final NoSuchMethodException e) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), classDoesNotHaveDefaultConstructor$str(), c), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleEndpointsWithOverlappingPaths = "UT003023: Multiple endpoints with the same logical mapping %s and %s";
    protected String multipleEndpointsWithOverlappingPaths$str() {
        return multipleEndpointsWithOverlappingPaths;
    }
    @Override
    public final DeploymentException multipleEndpointsWithOverlappingPaths(final PathTemplate template, final PathTemplate existing) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), multipleEndpointsWithOverlappingPaths$str(), template, existing));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotDeploy = "UT003024: Web socket deployment failed";
    protected String couldNotDeploy$str() {
        return couldNotDeploy;
    }
    @Override
    public final DeploymentException couldNotDeploy(final Exception e) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), couldNotDeploy$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotConnectUntilDeploymentComplete = "UT003025: Cannot connect until deployment is complete";
    protected String cannotConnectUntilDeploymentComplete$str() {
        return cannotConnectUntilDeploymentComplete;
    }
    @Override
    public final IllegalStateException cannotConnectUntilDeploymentComplete() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotConnectUntilDeploymentComplete$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAValidClientEndpointType = "UT003026: %s is not a valid client endpoint type";
    protected String notAValidClientEndpointType$str() {
        return notAValidClientEndpointType;
    }
    @Override
    public final DeploymentException notAValidClientEndpointType(final Class<?> type) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), notAValidClientEndpointType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String classWasNotAnnotated = "UT003027: Class %s was not annotated with @ClientEndpoint or @ServerEndpoint";
    protected String classWasNotAnnotated$str() {
        return classWasNotAnnotated;
    }
    @Override
    public final DeploymentException classWasNotAnnotated(final Class<?> endpoint) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), classWasNotAnnotated$str(), endpoint));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotFindDecoderForType = "UT003028: Could not find decoder for type %s on method %s";
    protected String couldNotFindDecoderForType$str() {
        return couldNotFindDecoderForType;
    }
    @Override
    public final DeploymentException couldNotFindDecoderForType(final Class<?> param, final Method method) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), couldNotFindDecoderForType$str(), param, method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotFindMessageParameter = "UT003029: Could not find message parameter on method %s";
    protected String couldNotFindMessageParameter$str() {
        return couldNotFindMessageParameter;
    }
    @Override
    public final DeploymentException couldNotFindMessageParameter(final Method method) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), couldNotFindMessageParameter$str(), method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String receivedTextFrameButNoMethod = "UT003030: Received a text frame however endpoint does not have a method capable of handling it";
    protected String receivedTextFrameButNoMethod$str() {
        return receivedTextFrameButNoMethod;
    }
    @Override
    public final RuntimeException receivedTextFrameButNoMethod() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), receivedTextFrameButNoMethod$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String receivedBinaryFrameButNoMethod = "UT003031: Received a binary frame however endpoint does not have a method capable of handling it";
    protected String receivedBinaryFrameButNoMethod$str() {
        return receivedBinaryFrameButNoMethod;
    }
    @Override
    public final RuntimeException receivedBinaryFrameButNoMethod() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), receivedBinaryFrameButNoMethod$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParametersWithWrongAnnotation = "UT003033: Method %s has invalid parameters at locations %s. It looks like you may have accidentally used javax.ws.rs.PathParam instead of javax.websocket.server.PathParam";
    protected String invalidParametersWithWrongAnnotation$str() {
        return invalidParametersWithWrongAnnotation;
    }
    @Override
    public final DeploymentException invalidParametersWithWrongAnnotation(final Method method, final java.util.Set<Integer> allParams) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), invalidParametersWithWrongAnnotation$str(), method, allParams));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String extensionWasNotPresentInClientHandshake = "UT003034: Server provided extension %s which was not in client supported extensions %s";
    protected String extensionWasNotPresentInClientHandshake$str() {
        return extensionWasNotPresentInClientHandshake;
    }
    @Override
    public final IOException extensionWasNotPresentInClientHandshake(final String e, final java.util.List<io.undertow.websockets.WebSocketExtension> supportedExtensions) {
        final IOException result = new IOException(String.format(getLoggingLocale(), extensionWasNotPresentInClientHandshake$str(), e, supportedExtensions));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String connectionTimedOut = "UT003035: Connection timed out";
    protected String connectionTimedOut$str() {
        return connectionTimedOut;
    }
    @Override
    public final IOException connectionTimedOut() {
        final IOException result = new IOException(String.format(getLoggingLocale(), connectionTimedOut$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String handlerIsNull = "UT003036: SendHandler is null";
    protected String handlerIsNull$str() {
        return handlerIsNull;
    }
    @Override
    public final IllegalArgumentException handlerIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), handlerIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String messageInNull = "UT003037: Message is null";
    protected String messageInNull$str() {
        return messageInNull;
    }
    @Override
    public final IllegalArgumentException messageInNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), messageInNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String messageTooLarge = "UT003038: Message of size %s was larger than the maximum of %s";
    protected String messageTooLarge$str() {
        return messageTooLarge;
    }
    @Override
    public final IllegalArgumentException messageTooLarge(final int size, final int max) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), messageTooLarge$str(), size, max));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInstantiateEndpoint = "UT003039: The container cannot find a suitable constructor to instantiate endpoint of type %s";
    protected String cannotInstantiateEndpoint$str() {
        return cannotInstantiateEndpoint;
    }
    @Override
    public final InstantiationException cannotInstantiateEndpoint(final Class<?> c) {
        final InstantiationException result = new InstantiationException(String.format(getLoggingLocale(), cannotInstantiateEndpoint$str(), c));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String endpointNotOfCorrectType = "UT003040: Annotated endpoint instance %s was not of correct type %s";
    protected String endpointNotOfCorrectType$str() {
        return endpointNotOfCorrectType;
    }
    @Override
    public final IllegalArgumentException endpointNotOfCorrectType(final Object instance, final Class expected) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), endpointNotOfCorrectType$str(), instance, expected));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String endpointDoesNotHaveAppropriateConstructor = "UT003041: Annotated endpoint %s does not have a no arg constructor, but is using a custom configurator. The custom configurator must create the instance.";
    protected String endpointDoesNotHaveAppropriateConstructor$str() {
        return endpointDoesNotHaveAppropriateConstructor;
    }
    @Override
    public final InstantiationException endpointDoesNotHaveAppropriateConstructor(final Class<?> endpoint) {
        final InstantiationException result = new InstantiationException(String.format(getLoggingLocale(), endpointDoesNotHaveAppropriateConstructor$str(), endpoint));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deploymentFailedDueToProgramaticErrors = "UT003042: Deployment failed due to invalid programmatically added endpoints";
    protected String deploymentFailedDueToProgramaticErrors$str() {
        return deploymentFailedDueToProgramaticErrors;
    }
    @Override
    public final RuntimeException deploymentFailedDueToProgramaticErrors() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), deploymentFailedDueToProgramaticErrors$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
