/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.flakytestextractor;

import io.zeebe.flakytestextractor.ExtendedReportTestCase;
import io.zeebe.flakytestextractor.ExtendedReportTestSuite;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.surefire.shared.utils.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtendedTestSuiteXMLParser
extends DefaultHandler {
    private final NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
    private final Log logger;
    private ExtendedReportTestSuite defaultSuite;
    private ExtendedReportTestSuite currentSuite;
    private Map<String, Integer> classesToSuitesIndex;
    private List<ExtendedReportTestSuite> suites;
    private StringBuilder currentElement;
    private ExtendedReportTestCase testCase;
    private boolean valid;

    public ExtendedTestSuiteXMLParser(Log logger) {
        this.logger = logger;
    }

    public List<ExtendedReportTestSuite> parse(String xmlPath) throws ParserConfigurationException, SAXException, IOException {
        File f = new File(xmlPath);
        try (InputStreamReader stream = new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);){
            List<ExtendedReportTestSuite> list = this.parse(stream);
            return list;
        }
    }

    public List<ExtendedReportTestSuite> parse(InputStreamReader stream) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        this.valid = true;
        this.classesToSuitesIndex = new HashMap<String, Integer>();
        this.suites = new ArrayList<ExtendedReportTestSuite>();
        saxParser.parse(new InputSource(stream), (DefaultHandler)this);
        if (this.currentSuite != this.defaultSuite && this.defaultSuite.getNumberOfTests() == 0) {
            this.suites.remove(this.classesToSuitesIndex.get(this.defaultSuite.getFullClassName()));
        }
        return this.suites;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.valid) {
            try {
                switch (qName) {
                    case "testsuite": {
                        this.currentSuite = this.defaultSuite = new ExtendedReportTestSuite();
                        try {
                            Number time = this.numberFormat.parse(attributes.getValue("time"));
                            this.defaultSuite.setTimeElapsed(time.floatValue());
                        }
                        catch (NullPointerException e) {
                            this.logger.error((CharSequence)"WARNING: no time attribute found on testsuite element");
                        }
                        String name = attributes.getValue("name");
                        String group = attributes.getValue("group");
                        this.defaultSuite.setFullClassName(StringUtils.isBlank((String)group) ? name : group + "." + name);
                        this.suites.add(this.defaultSuite);
                        this.classesToSuitesIndex.put(this.defaultSuite.getFullClassName(), this.suites.size() - 1);
                        break;
                    }
                    case "testcase": {
                        String timeAsString;
                        this.currentElement = new StringBuilder();
                        this.testCase = new ExtendedReportTestCase().setName(attributes.getValue("name"));
                        String fullClassName = attributes.getValue("classname");
                        if (fullClassName != null) {
                            Integer currentSuiteIndex = this.classesToSuitesIndex.get(fullClassName);
                            if (currentSuiteIndex == null) {
                                this.currentSuite = new ExtendedReportTestSuite().setFullClassName(fullClassName);
                                this.suites.add(this.currentSuite);
                                this.classesToSuitesIndex.put(fullClassName, this.suites.size() - 1);
                            } else {
                                this.currentSuite = this.suites.get(currentSuiteIndex);
                            }
                        }
                        Integer time = StringUtils.isBlank((String)(timeAsString = attributes.getValue("time"))) ? (Number)0 : (Number)this.numberFormat.parse(timeAsString);
                        this.testCase.setFullClassName(this.currentSuite.getFullClassName()).setClassName(this.currentSuite.getName()).setFullName(this.currentSuite.getFullClassName() + "." + this.testCase.getName()).setTime(((Number)time).floatValue());
                        if (this.currentSuite == this.defaultSuite) break;
                        this.currentSuite.setTimeElapsed(this.testCase.getTime() + this.currentSuite.getTimeElapsed());
                        break;
                    }
                    case "failure": {
                        this.testCase.setFailureMessage(attributes.getValue("message")).setFailureType(attributes.getValue("type"));
                        this.currentSuite.incrementNumberOfFailures();
                        break;
                    }
                    case "error": {
                        this.testCase.setFailureMessage(attributes.getValue("message")).setFailureType(attributes.getValue("type"));
                        this.currentSuite.incrementNumberOfErrors();
                        break;
                    }
                    case "skipped": {
                        String message = attributes.getValue("message");
                        this.testCase.setSkipped(message != null ? message : "skipped");
                        this.currentSuite.incrementNumberOfSkipped();
                        break;
                    }
                    case "flakyFailure": 
                    case "flakyError": {
                        this.testCase.setFlake();
                        this.testCase.setFailureMessage(attributes.getValue("message")).setFailureType(attributes.getValue("type"));
                        this.currentSuite.incrementNumberOfFlakes();
                        break;
                    }
                    case "failsafe-summary": {
                        this.valid = false;
                        break;
                    }
                    case "system-out": 
                    case "system-err": 
                    case "stackTrace": {
                        this.currentElement = new StringBuilder();
                        break;
                    }
                }
            }
            catch (ParseException e) {
                throw new SAXException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (qName) {
            case "testcase": {
                this.currentSuite.getTestCases().add(this.testCase);
                break;
            }
            case "stackTrace": 
            case "failure": 
            case "error": {
                this.testCase.setFailureDetail(this.currentElement.toString()).setFailureErrorLine(ExtendedTestSuiteXMLParser.parseErrorLine(this.currentElement, this.testCase.getFullClassName()));
                break;
            }
            case "system-out": {
                this.testCase.setSystemOut(this.currentElement.toString());
                break;
            }
            case "system-err": {
                this.testCase.setSystemError(this.currentElement.toString());
                break;
            }
            case "time": {
                try {
                    this.defaultSuite.setTimeElapsed(this.numberFormat.parse(this.currentElement.toString()).floatValue());
                    break;
                }
                catch (ParseException e) {
                    throw new SAXException(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        assert (start >= 0);
        assert (length >= 0);
        if (this.valid && ExtendedTestSuiteXMLParser.isNotBlank(start, length, ch)) {
            this.currentElement.append(ch, start, length);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    static boolean isNotBlank(int from, int len, char ... s) {
        assert (from >= 0);
        assert (len >= 0);
        if (s != null) {
            for (int i = 0; i < len; ++i) {
                char c;
                if ((c = s[from++]) == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f') continue;
                return true;
            }
        }
        return false;
    }

    static boolean isNumeric(StringBuilder s, int from, int to) {
        assert (from >= 0);
        assert (from <= to);
        int i = from;
        while (i != to) {
            if (Character.isDigit(s.charAt(i++))) continue;
            return false;
        }
        return from != to;
    }

    static String parseErrorLine(StringBuilder currentElement, String fullClassName) {
        String[] linePatterns = new String[]{"at " + fullClassName + '.', "at " + fullClassName + '$'};
        int[] indexes = ExtendedTestSuiteXMLParser.lastIndexOf(currentElement, linePatterns);
        int patternStartsAt = indexes[0];
        if (patternStartsAt != -1) {
            int searchTo;
            int searchFrom = patternStartsAt + linePatterns[indexes[1]].length();
            return ExtendedTestSuiteXMLParser.isNumeric(currentElement, searchFrom = 1 + currentElement.indexOf(":", searchFrom), searchTo = currentElement.indexOf(")", searchFrom)) ? currentElement.substring(searchFrom, searchTo) : "";
        }
        return "";
    }

    static int[] lastIndexOf(StringBuilder source, String ... linePatterns) {
        int end = source.indexOf("Caused by:");
        if (end == -1) {
            end = source.length();
        }
        int startsAt = -1;
        int pattern = -1;
        for (int i = 0; i < linePatterns.length; ++i) {
            String linePattern = linePatterns[i];
            int currentStartsAt = source.lastIndexOf(linePattern, end);
            if (currentStartsAt <= startsAt) continue;
            startsAt = currentStartsAt;
            pattern = i;
        }
        return new int[]{startsAt, pattern};
    }
}

