/*
 * Decompiled with CFR 0.152.
 */
package brave.mongodb;

import brave.Tracing;
import brave.mongodb.TraceMongoCommandListener;
import com.mongodb.event.CommandListener;

public final class MongoDBTracing {
    final Tracing tracing;

    public static MongoDBTracing create(Tracing tracing) {
        return MongoDBTracing.newBuilder(tracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return new Builder(tracing);
    }

    public CommandListener commandListener() {
        return new TraceMongoCommandListener(this);
    }

    MongoDBTracing(Builder builder) {
        this.tracing = builder.tracing;
    }

    public static final class Builder {
        final Tracing tracing;

        Builder(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("tracing == null");
            }
            this.tracing = tracing;
        }

        public MongoDBTracing build() {
            return new MongoDBTracing(this);
        }
    }
}

