/*
 * Decompiled with CFR 0.152.
 */
package brave.mongodb;

import brave.Span;
import brave.internal.Throwables;
import com.mongodb.ServerAddress;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.InetSocketAddress;

class MongoDBDriver {
    private static final MongoDBDriver MONGO_DB_DRIVER = MongoDBDriver.findMongoDBDriver();

    void setRemoteIpAndPort(Span span, ServerAddress address) {
    }

    MongoDBDriver() {
    }

    public static MongoDBDriver get() {
        return MONGO_DB_DRIVER;
    }

    private static MongoDBDriver findMongoDBDriver() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MethodHandle getHost = lookup.findVirtual(ServerAddress.class, "getHost", MethodType.methodType(String.class));
            MethodHandle getPort = lookup.findVirtual(ServerAddress.class, "getPort", MethodType.methodType(Integer.TYPE));
            return new Driver5x(getHost, getPort);
        }
        catch (IllegalAccessException | NoSuchMethodException getHost) {
            try {
                MethodHandle getSocketAddress = lookup.findVirtual(ServerAddress.class, "getSocketAddress", MethodType.methodType(InetSocketAddress.class));
                return new Driver3x(getSocketAddress);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                return new MongoDBDriver();
            }
        }
    }

    static final class Driver5x
    extends MongoDBDriver {
        final MethodHandle getHost;
        final MethodHandle getPort;

        Driver5x(MethodHandle getHost, MethodHandle getPort) {
            this.getHost = getHost;
            this.getPort = getPort;
        }

        @Override
        void setRemoteIpAndPort(Span span, ServerAddress serverAddress) {
            try {
                String host = this.getHost.invokeExact(serverAddress);
                int port = this.getPort.invokeExact(serverAddress);
                span.remoteIpAndPort(host, port);
            }
            catch (Throwable t) {
                Throwables.propagateIfFatal((Throwable)t);
            }
        }
    }

    static final class Driver3x
    extends MongoDBDriver {
        final MethodHandle getSocketAddress;

        Driver3x(MethodHandle getSocketAddress) {
            this.getSocketAddress = getSocketAddress;
        }

        @Override
        void setRemoteIpAndPort(Span span, ServerAddress serverAddress) {
            try {
                InetSocketAddress socketAddress = this.getSocketAddress.invokeExact(serverAddress);
                span.remoteIpAndPort(socketAddress.getAddress().getHostAddress(), socketAddress.getPort());
            }
            catch (Throwable t) {
                Throwables.propagateIfFatal((Throwable)t);
            }
        }
    }
}

