/*
 * Decompiled with CFR 0.152.
 */
package it.krzeminski.snakeyaml.engine.kmp.internal.utils;

import it.krzeminski.snakeyaml.engine.kmp.nodes.MappingNode;
import it.krzeminski.snakeyaml.engine.kmp.nodes.Node;
import it.krzeminski.snakeyaml.engine.kmp.nodes.NodeTuple;
import it.krzeminski.snakeyaml.engine.kmp.nodes.ScalarNode;
import it.krzeminski.snakeyaml.engine.kmp.nodes.SequenceNode;
import it.krzeminski.snakeyaml.engine.kmp.nodes.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005J<\u0010\f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/internal/utils/MergeUtils;", "", "asMappingNode", "Lkotlin/Function1;", "Lit/krzeminski/snakeyaml/engine/kmp/nodes/Node;", "Lit/krzeminski/snakeyaml/engine/kmp/nodes/MappingNode;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "flatten", "", "Lit/krzeminski/snakeyaml/engine/kmp/nodes/NodeTuple;", "node", "filter", "Lkotlin/Pair;", "", "", "mergables", "snakeyaml-engine-kmp"})
public final class MergeUtils {
    @NotNull
    private final Function1<Node, MappingNode> asMappingNode;

    public MergeUtils(@NotNull Function1<? super Node, MappingNode> asMappingNode) {
        Intrinsics.checkNotNullParameter(asMappingNode, (String)"asMappingNode");
        this.asMappingNode = asMappingNode;
    }

    @NotNull
    public final List<NodeTuple> flatten(@NotNull MappingNode node) {
        List toProcess;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List result = toProcess = node.getValue();
        boolean process = true;
        while (process) {
            process = false;
            ArrayList updated = new ArrayList(toProcess.size());
            HashSet keys = new HashSet(toProcess.size());
            ArrayList merges = new ArrayList(2);
            for (NodeTuple tuple : toProcess) {
                Node keyNode = tuple.getKeyNode();
                if (Intrinsics.areEqual((Object)keyNode.getTag(), (Object)Tag.MERGE)) {
                    ((Collection)merges).add(tuple);
                    continue;
                }
                ((Collection)updated).add(tuple);
                if (!(keyNode instanceof ScalarNode)) continue;
                ((Collection)keys).add(((ScalarNode)keyNode).getValue());
            }
            Iterator iterator = merges.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<NodeTuple> iterator2 = iterator;
            while (iterator2.hasNext()) {
                NodeTuple tuple;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                Node valueNode = tuple.getValueNode();
                if (valueNode instanceof SequenceNode) {
                    for (Node ref : ((SequenceNode)valueNode).getValue()) {
                        MappingNode mergable = (MappingNode)this.asMappingNode.invoke((Object)ref);
                        process = process || mergable.getHasMergeTag();
                        Pair<List<NodeTuple>, Set<String>> filtered = this.filter(mergable.getValue(), keys);
                        CollectionsKt.addAll((Collection)updated, (Iterable)((Iterable)filtered.getFirst()));
                        CollectionsKt.addAll((Collection)keys, (Iterable)((Iterable)filtered.getSecond()));
                    }
                    continue;
                }
                MappingNode mergable = (MappingNode)this.asMappingNode.invoke((Object)valueNode);
                process = process || mergable.getHasMergeTag();
                Pair<List<NodeTuple>, Set<String>> filtered = this.filter(mergable.getValue(), keys);
                CollectionsKt.addAll((Collection)updated, (Iterable)((Iterable)filtered.getFirst()));
                CollectionsKt.addAll((Collection)keys, (Iterable)((Iterable)filtered.getSecond()));
            }
            result = updated;
            if (!process) continue;
            toProcess = updated;
        }
        return result;
    }

    private final Pair<List<NodeTuple>, Set<String>> filter(List<NodeTuple> mergables, Set<String> filter) {
        int size = mergables.size();
        HashSet keys = new HashSet(size);
        ArrayList result = new ArrayList(size);
        for (NodeTuple tuple : mergables) {
            Node key = tuple.getKeyNode();
            if (key instanceof ScalarNode) {
                String nodeValue = ((ScalarNode)key).getValue();
                if (filter.contains(nodeValue)) continue;
                ((Collection)result).add(tuple);
                ((Collection)keys).add(nodeValue);
                continue;
            }
            ((Collection)result).add(tuple);
        }
        return new Pair(result, keys);
    }
}

