/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.mgcp.message;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.message.parms.BearerInformation;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionParm;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotificationRequestParms;
import jain.protocol.ip.mgcp.message.parms.ReasonCode;

public final class DeleteConnection
extends JainMgcpCommandEvent {
    private CallIdentifier callIdentifier = null;
    private ConnectionIdentifier connectionIdentifier = null;
    private ConnectionParm[] connectionParms = null;
    private BearerInformation bearerInformation = null;
    private NotificationRequestParms notificationRequestParms = null;
    private ReasonCode reasonCode = null;

    public DeleteConnection(Object source, CallIdentifier callIdentifier, EndpointIdentifier endpointIdentifier, ConnectionIdentifier connectionIdentifier) throws IllegalArgumentException {
        this(source, endpointIdentifier);
        this.setCallIdentifier(callIdentifier);
        this.setConnectionIdentifier(connectionIdentifier);
    }

    public DeleteConnection(Object source, CallIdentifier callIdentifier, EndpointIdentifier endpointIdentifier, ConnectionIdentifier connectionIdentifier, ReasonCode reasonCode, ConnectionParm[] connectionParms) throws IllegalArgumentException {
        this(source, callIdentifier, endpointIdentifier, connectionIdentifier);
        this.setReasonCode(reasonCode);
        this.setConnectionParms(connectionParms);
    }

    public DeleteConnection(Object source, CallIdentifier callIdentifier, EndpointIdentifier endpointIdentifier) throws IllegalArgumentException {
        this(source, endpointIdentifier);
        this.setCallIdentifier(callIdentifier);
    }

    public DeleteConnection(Object source, EndpointIdentifier endpointIdentifier) throws IllegalArgumentException {
        super(source, endpointIdentifier, 104);
    }

    public void setCallIdentifier(CallIdentifier callIdentifier) throws IllegalArgumentException {
        if (callIdentifier == null) {
            throw new IllegalArgumentException("Call identifier cannot be null-valued!");
        }
        this.callIdentifier = callIdentifier;
    }

    public void setConnectionIdentifier(ConnectionIdentifier connectionIdentifier) throws IllegalArgumentException {
        if (connectionIdentifier == null) {
            throw new IllegalArgumentException("Connection identifier cannot be null-valued!");
        }
        this.connectionIdentifier = connectionIdentifier;
    }

    public void setNotificationRequestParms(NotificationRequestParms notificationRequestParms) {
        this.notificationRequestParms = notificationRequestParms;
    }

    public void setBearerInformation(BearerInformation bearerInformation) {
        this.bearerInformation = bearerInformation;
    }

    public void setReasonCode(ReasonCode reasonCode) throws IllegalArgumentException {
        if (reasonCode == null) {
            throw new IllegalArgumentException("Reason code cannot be null-valued!");
        }
        this.reasonCode = reasonCode;
    }

    public ReasonCode getReasonCode() {
        return this.reasonCode;
    }

    public void setConnectionParms(ConnectionParm[] connectionParms) throws IllegalArgumentException {
        if (connectionParms == null) {
            throw new IllegalArgumentException("List of connection parameters cannot be null-valued!");
        }
        int i = 0;
        while (i < connectionParms.length) {
            if (connectionParms[i] == null) {
                throw new IllegalArgumentException("Entry " + i + " of the list of connection parameters is null-valued.  " + "Must be non-null!");
            }
            ++i;
        }
        this.connectionParms = connectionParms;
    }

    public ConnectionParm[] getConnectionParms() {
        return this.connectionParms;
    }

    public CallIdentifier getCallIdentifier() {
        return this.callIdentifier;
    }

    public ConnectionIdentifier getConnectionIdentifier() {
        return this.connectionIdentifier;
    }

    public NotificationRequestParms getNotificationRequestParms() {
        return this.notificationRequestParms;
    }

    public BearerInformation getBearerInformation() {
        return this.bearerInformation;
    }

    public String toString() {
        String text = super.BuildCommandHeader("DLCX");
        if (this.callIdentifier != null) {
            text = text + "C: " + this.callIdentifier.toString() + "\n";
        }
        if (this.connectionIdentifier != null) {
            text = text + "I: " + this.connectionIdentifier.toString() + "\n";
        }
        if (this.connectionParms != null) {
            text = text + super.BuildListParmLine("P", this.connectionParms);
        }
        if (this.bearerInformation != null) {
            text = text + "B: e:" + this.bearerInformation.toString() + "\n";
        }
        if (this.notificationRequestParms != null) {
            text = text + this.notificationRequestParms.toString();
        }
        if (this.reasonCode != null) {
            text = text + "E: " + this.reasonCode.toString() + "\n";
        }
        return text;
    }
}

