/*
 * Decompiled with CFR 0.152.
 */
package arjuna.JavaSim.Statistics;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class Mean {
    protected double _Max;
    protected double _Min;
    protected double _Sum;
    protected double _Mean;
    protected int _Number;

    public Mean() {
        this.reset();
    }

    public void setValue(double value) throws IllegalArgumentException {
        if (value > this._Max) {
            this._Max = value;
        }
        if (value < this._Min) {
            this._Min = value;
        }
        this._Sum += value;
        ++this._Number;
        this._Mean = this._Sum / (double)this._Number;
    }

    public void reset() {
        this._Max = 1.4E-45f;
        this._Min = 3.4028234663852886E38;
        this._Mean = 0.0;
        this._Sum = 0.0;
        this._Number = 0;
    }

    public int numberOfSamples() {
        return this._Number;
    }

    public double min() {
        return this._Min;
    }

    public double max() {
        return this._Max;
    }

    public double sum() {
        return this._Sum;
    }

    public double mean() {
        return this._Mean;
    }

    public boolean saveState(String fileName) throws IOException {
        FileOutputStream f = new FileOutputStream(fileName);
        DataOutputStream oFile = new DataOutputStream(f);
        boolean res = this.saveState(oFile);
        f.close();
        return res;
    }

    public boolean saveState(DataOutputStream oFile) throws IOException {
        oFile.writeDouble(this._Max);
        oFile.writeDouble(this._Min);
        oFile.writeDouble(this._Sum);
        oFile.writeDouble(this._Mean);
        oFile.writeInt(this._Number);
        return true;
    }

    public boolean restoreState(String fileName) throws FileNotFoundException, IOException {
        FileInputStream f = new FileInputStream(fileName);
        DataInputStream iFile = new DataInputStream(f);
        boolean res = this.restoreState(iFile);
        f.close();
        return res;
    }

    public boolean restoreState(DataInputStream iFile) throws IOException {
        this._Max = iFile.readDouble();
        this._Min = iFile.readDouble();
        this._Sum = iFile.readDouble();
        this._Mean = iFile.readDouble();
        this._Number = iFile.readInt();
        return true;
    }

    public void print() {
        System.out.println("Number of samples : " + this.numberOfSamples());
        System.out.println("Minimum           : " + this.min());
        System.out.println("Maximum           : " + this.max());
        System.out.println("Sum               : " + this.sum());
        System.out.println("Mean              : " + this.mean());
    }
}

